/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompletionUtil {
    public static final int CSS_SELECTOR_SUFFIX_PRIORITY = 20;
    public static final int CSS_SELECTOR_SUFFIX_FROM_HTML_PRIORITY = 10;
    public static final int CSS_KEYWORDS_PRIORITY = 20;
    private static final InsertHandler<LookupElement> SELECTOR_SUFFIX_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            PsiElement element = item.getPsiElement();
            if (element instanceof CssSelectorSuffix) {
                Document document = context.getDocument();
                int startOffset = context.getStartOffset();
                int tailOffset = context.getTailOffset();
                if (0 <= startOffset && startOffset < document.getTextLength() && 0 <= tailOffset && tailOffset < document.getTextLength()) {
                    document.replaceString(startOffset, tailOffset, (CharSequence)item.getLookupString());
                }
            }
        }
    };

    @NotNull
    public static LookupElement lookupForSelectorSuffix(@NotNull String name, @NotNull CssSelectorSuffix selectorSuffix, @Nullable PsiFile contextFile) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        if (selectorSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)selectorSuffix).withCaseSensitivity(false).withInsertHandler(SELECTOR_SUFFIX_INSERT_HANDLER);
        ItemPresentation presentation = selectorSuffix.getPresentation();
        assert (presentation != null);
        int priority = 20;
        PsiFile containingFile = selectorSuffix.getContainingFile();
        if (contextFile == containingFile) {
            priority += 10;
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withIcon(presentation.getIcon(false)).withTypeText(presentation.getLocationString()), (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupForSelectorSuffixFromHtml(@NotNull String name, @NotNull CssSelectorSuffixType type, @Nullable VirtualFile containingFile, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        LookupElement lookupElement = CssCompletionUtil.lookupForSelectorSuffixFromHtml(name, type, containingFile, project, 0);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupForSelectorSuffixFromHtml(@NotNull String name, @NotNull CssSelectorSuffixType type, @Nullable VirtualFile containingFile, @Nullable Project project, int extraPriority) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)name).withIcon(type.getIcon()).withTypeText(containingFile != null ? CssCompletionUtil.getContainingFileText(containingFile, project) : "from html").withCaseSensitivity(false).withInsertHandler(SELECTOR_SUFFIX_INSERT_HANDLER);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder, (double)(10 + extraPriority));
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        return lookupElement;
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForKeyword"));
        }
        return CssCompletionUtil.lookupForKeyword(lookupString, null);
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForKeyword"));
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)lookupString).bold().withInsertHandler(insertHandler);
        return PrioritizedLookupElement.withPriority((LookupElement)builder, (double)20.0);
    }

    private static String getContainingFileText(@NotNull VirtualFile file, @Nullable Project project) {
        String relativePath;
        ProjectFileIndex index;
        VirtualFile rootForFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/util/CssCompletionUtil", "getContainingFileText"));
        }
        if (project != null && (rootForFile = (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).getContentRootForFile(file)) != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)rootForFile, (char)File.separatorChar)) != null) {
            return relativePath;
        }
        return file.getName();
    }

    @NotNull
    public static CompletionResultSet fixPrefixForVendorPrefixes(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, IElementType ... typesToFix) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
        }
        if (typesToFix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesToFix", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
        }
        PsiElement position = parameters.getPosition();
        IElementType type = position.getNode().getElementType();
        if (CssElementTypes.NAME_TOKEN_TYPES.contains(type) || type == CssElementTypes.CSS_ATKEYWORD || TokenSet.create((IElementType[])typesToFix).contains(type)) {
            String positionText = position.getText();
            int prefixShift = parameters.getOffset() - position.getTextRange().getStartOffset();
            if (0 < prefixShift && prefixShift < positionText.length()) {
                CompletionResultSet completionResultSet = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(positionText.substring(0, prefixShift)));
                if (completionResultSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
                }
                return completionResultSet;
            }
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
        }
        return completionResultSet;
    }
}

