/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSpringModelImpl
extends XmlSpringModel {
    @NotNull
    private final Set<XmlFile> myConfigFiles;

    public XmlSpringModelImpl(@NotNull Set<XmlFile> configFiles, @NotNull Module module, @Nullable SpringFileSet fileSet) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/spring/contexts/model/XmlSpringModelImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/XmlSpringModelImpl", "<init>"));
        }
        super(module, fileSet);
        this.myConfigFiles = configFiles;
    }

    @NotNull
    public Set<CommonSpringModel> getModelsToProcess(boolean checkActiveProfiles) {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        models.addAll(this.getLocalSpringModels());
        models.addAll(this.getDependencies());
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/XmlSpringModelImpl", "getModelsToProcess"));
        }
        return linkedHashSet;
    }

    public Set<LocalXmlModel> getLocalSpringModels() {
        SpringFileSet fileSet = this.getFileSet();
        Set activeProfiles = fileSet == null ? this.getActiveProfiles() : fileSet.getActiveProfiles();
        return new LinkedHashSet<LocalXmlModel>(ContainerUtil.mapNotNull(this.getXmlConfigFiles(), xmlFile -> SpringCachedModelFactory.getOrCreateLocalXmlModel(xmlFile, this.getModule(), activeProfiles)));
    }

    @NotNull
    public Set<String> getAllProfiles() {
        LinkedHashSet<String> profiles = new LinkedHashSet<String>();
        for (CommonSpringModel commonSpringModel : this.getLocalSpringModels()) {
            profiles.addAll(commonSpringModel.getAllProfiles());
        }
        LinkedHashSet<String> linkedHashSet = profiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/XmlSpringModelImpl", "getAllProfiles"));
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<XmlFile> getXmlConfigFiles() {
        Set<XmlFile> set = this.myConfigFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/XmlSpringModelImpl", "getXmlConfigFiles"));
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/XmlSpringModelImpl", "hasConfigFile"));
        }
        if (configFile instanceof XmlFile) {
            if (this.myConfigFiles.contains(configFile)) {
                return true;
            }
            if (this.hasImportedConfigs((XmlFile)configFile)) {
                return true;
            }
        }
        for (SpringModel model : this.getDependencies()) {
            if (!model.hasConfigFile(configFile)) continue;
            return true;
        }
        return false;
    }

    private boolean hasImportedConfigs(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/contexts/model/XmlSpringModelImpl", "hasImportedConfigs"));
        }
        CommonProcessors.FindFirstProcessor<CommonSpringModel> firstProcessor = new CommonProcessors.FindFirstProcessor<CommonSpringModel>(){

            protected boolean accept(CommonSpringModel model) {
                return model instanceof LocalXmlModel && ((XmlFile)((LocalXmlModel)model).getConfig()).equals(file);
            }
        };
        for (LocalXmlModel model : this.getLocalSpringModels()) {
            model.processRelatedModels((Processor)firstProcessor);
            if (!firstProcessor.isFound()) continue;
            return true;
        }
        return false;
    }

    public Set<DomFileElement<Beans>> getLocalModelsRoots() {
        Set<LocalXmlModel> localModels = this.getLocalSpringModels();
        LinkedHashSet<DomFileElement<Beans>> set = new LinkedHashSet<DomFileElement<Beans>>(localModels.size());
        for (LocalXmlModel localXmlModel : localModels) {
            DomFileElement root = localXmlModel.getRoot();
            ContainerUtil.addIfNotNull(set, (Object)root);
        }
        return set;
    }
}

