/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Scope;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.xml.util.PsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DuplicatedBeanNamesInspection
extends SpringBeanInspectionBase {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        XmlFile xmlFile = domFileElement.getFile();
        SpringModel model = SpringManager.getInstance((Project)xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
        if (model == null) {
            return;
        }
        Beans beans = (Beans)domFileElement.getRootElement();
        DuplicatedBeanNamesInspection.checkRootBeans(holder, model, beans);
    }

    private static void checkRootBeans(DomElementAnnotationHolder holder, SpringModel model, Beans beans) {
        DuplicatedBeanNamesInspection.checkBeans(holder, model, beans);
        for (Beans beanProfiles : beans.getBeansProfiles()) {
            DuplicatedBeanNamesInspection.checkRootBeans(holder, model, beanProfiles);
        }
    }

    private static void checkBeans(DomElementAnnotationHolder holder, SpringModel model, Beans beans) {
        ArrayList allBeans = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(allBeans);
        SpringBeanUtils.getInstance().processChildBeans((DomElement)beans, false, processor);
        for (CommonSpringBean bean : allBeans) {
            if (!(bean instanceof DomSpringBean)) continue;
            DuplicatedBeanNamesInspection.checkBean((DomSpringBean)bean, holder, model);
        }
        for (Alias alias : beans.getAliases()) {
            DuplicatedBeanNamesInspection.checkAlias(alias, holder, model);
        }
    }

    private static void checkBean(DomSpringBean bean, DomElementAnnotationHolder holder, SpringModel springModel) {
        SpringBean springBean;
        GenericAttributeValue name;
        String value;
        LocalQuickFix[] fixes;
        GenericAttributeValue beanId = bean.getId();
        String id = beanId.getStringValue();
        if (id != null && beanId.getAnnotation(Scope.class) == null && (fixes = DuplicatedBeanNamesInspection.getFixes(id, (PsiElementPointer)BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean), springModel)).length > 0) {
            holder.createProblem((DomElement)beanId, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.duplicate.bean.name", new Object[0]), fixes);
        }
        if (bean instanceof SpringBean && (value = (name = (springBean = (SpringBean)bean).getName()).getStringValue()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",; ");
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                LocalQuickFix[] fixes2 = DuplicatedBeanNamesInspection.getFixes(s, (PsiElementPointer)BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean), springModel);
                if (fixes2.length <= 0) continue;
                holder.createProblem((DomElement)name, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.duplicate.bean.name", new Object[0]), TextRange.from((int)(tokenizer.getCurrentPosition() - s.length() + 1), (int)s.length()), fixes2);
            }
        }
    }

    private static void checkAlias(Alias alias, DomElementAnnotationHolder holder, SpringModel model) {
        LocalQuickFix[] fixes;
        GenericAttributeValue value = alias.getAlias();
        String aliasName = value.getStringValue();
        if (aliasName != null && (fixes = DuplicatedBeanNamesInspection.getFixes(aliasName, (PsiElementPointer)DomService.getInstance().createAnchor((DomElement)alias), model)).length > 0) {
            holder.createProblem((DomElement)value, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.duplicate.bean.name", new Object[0]), fixes);
        }
    }

    private static LocalQuickFix[] getFixes(final String name, final PsiElementPointer bean, SpringModel model) {
        final Collection pointers = model.getDuplicatedNames(name);
        if (pointers.isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix fix = new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                if ("View duplicates" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/DuplicatedBeanNamesInspection$1", "getFamilyName"));
                }
                return "View duplicates";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/DuplicatedBeanNamesInspection$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/DuplicatedBeanNamesInspection$1", "applyFix"));
                }
                List duplications = ContainerUtil.mapNotNull((Collection)pointers, (Function)new MyFunction(bean, name));
                if (duplications.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    NavigationUtil.getPsiElementPopup((PsiElement[])PsiUtilCore.toPsiElementArray((Collection)duplications), (String)"View Duplicates").showInBestPositionFor(DataManager.getInstance().getDataContext());
                } else {
                    ((FakePsiElement)duplications.get(0)).navigate(true);
                }
            }
        };
        return new LocalQuickFix[]{fix};
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("DuplicatedBeanNamesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/DuplicatedBeanNamesInspection", "getShortName"));
        }
        return "DuplicatedBeanNamesInspection";
    }

    private static class MyFunction
    implements NullableFunction<PsiElementPointer, FakePsiElement> {
        private final PsiElementPointer myBean;
        private final String myName;

        public MyFunction(PsiElementPointer bean, String name) {
            this.myBean = bean;
            this.myName = name;
        }

        public FakePsiElement fun(final PsiElementPointer pointer) {
            final PsiElement psiElement = pointer.getPsiElement();
            if (psiElement == null) {
                return null;
            }
            final PsiFile containingFile = psiElement.getContainingFile();
            return psiElement.equals(this.myBean.getPsiElement()) ? null : new FakePsiElement(){

                @NotNull
                public PsiElement getNavigationElement() {
                    PsiElement psiElement2 = psiElement;
                    if (psiElement2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/DuplicatedBeanNamesInspection$MyFunction$1", "getNavigationElement"));
                    }
                    return psiElement2;
                }

                public String getName() {
                    return myName;
                }

                public Icon getIcon(boolean open) {
                    return pointer instanceof SpringBeanPointer ? SpringPresentationProvider.getSpringIcon((Object)pointer) : null;
                }

                public PsiElement getParent() {
                    return containingFile;
                }

                public String getLocationString() {
                    return "(" + containingFile.getName() + ")";
                }
            };
        }
    }
}

