/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.search.executors;

import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.utils.search.executors.AbstractSpringBeanQueryExecutor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringBeanFactoriesQueryExecutor
extends AbstractSpringBeanQueryExecutor {
    public static final SpringBeanFactoriesQueryExecutor INSTANCE = new SpringBeanFactoriesQueryExecutor();

    public void processQuery(@NotNull SpringBeanSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> consumer) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/SpringBeanFactoriesQueryExecutor", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spring/model/utils/search/executors/SpringBeanFactoriesQueryExecutor", "processQuery"));
        }
        if (!SpringBeanFactoriesQueryExecutor.processEffectiveBeanTypes(SpringBeanFactoriesQueryExecutor.getIndexedFactoryBeans(params), params, consumer)) {
            return;
        }
        SpringBeanFactoriesQueryExecutor.processEffectiveBeanTypes(SpringBeanFactoriesQueryExecutor.getIndexedFactoryMethods(params), params, consumer);
    }

    @NotNull
    private static Collection<SpringBeanPointer> getIndexedFactoryBeans(@NotNull SpringBeanSearchParameters.BeanClass params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/SpringBeanFactoriesQueryExecutor", "getIndexedFactoryBeans"));
        }
        CommonProcessors.CollectProcessor collectBeans = new CommonProcessors.CollectProcessor();
        SpringXmlBeansIndex.processFactoryBeans(params, (Processor<SpringBeanPointer>)collectBeans);
        Collection collection = collectBeans.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/search/executors/SpringBeanFactoriesQueryExecutor", "getIndexedFactoryBeans"));
        }
        return collection;
    }

    @NotNull
    private static Collection<SpringBeanPointer> getIndexedFactoryMethods(@NotNull SpringBeanSearchParameters.BeanClass params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/SpringBeanFactoriesQueryExecutor", "getIndexedFactoryMethods"));
        }
        CommonProcessors.CollectProcessor collectMethods = new CommonProcessors.CollectProcessor();
        SpringXmlBeansIndex.processFactoryMethods(params, (Processor<SpringBeanPointer>)collectMethods);
        Collection collection = collectMethods.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/search/executors/SpringBeanFactoriesQueryExecutor", "getIndexedFactoryMethods"));
        }
        return collection;
    }
}

