/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.localRun;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ScriptUtil {
    private ScriptUtil() {
    }

    public static void appendEnvVariableDeclaration(@NotNull String name, @NotNull String value, @NotNull StringBuilder buffer) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javaee/run/localRun/ScriptUtil", "appendEnvVariableDeclaration"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javaee/run/localRun/ScriptUtil", "appendEnvVariableDeclaration"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/javaee/run/localRun/ScriptUtil", "appendEnvVariableDeclaration"));
        }
        if (SystemInfo.isWindows) {
            buffer.append("SET ");
        }
        buffer.append(name);
        buffer.append("=");
        buffer.append(value);
        buffer.append("\n");
        if (SystemInfo.isUnix) {
            buffer.append("export ");
            buffer.append(name);
            buffer.append("\n");
        }
    }

    public static void appendEnvVariableReference(@NotNull String name, @NotNull StringBuilder buffer) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javaee/run/localRun/ScriptUtil", "appendEnvVariableReference"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/javaee/run/localRun/ScriptUtil", "appendEnvVariableReference"));
        }
        if (SystemInfo.isWindows) {
            buffer.append("%").append(name).append("%");
        } else {
            buffer.append("${").append(name).append("}");
        }
    }

    public static File createScriptFile(File directory, String fileName) throws IOException {
        File result = new File(directory, fileName + ScriptUtil.getScriptExtension());
        FileUtil.createIfDoesntExist((File)result);
        ScriptUtil.makeExecutable(result);
        return result;
    }

    public static void makeExecutable(File result) throws IOException {
        if (SystemInfo.isUnix) {
            result.setExecutable(true);
        }
    }

    public static String getScriptExtension() {
        return SystemInfo.isWindows ? "cmd" : "sh";
    }

    public static GeneralCommandLine createCommandLine(String ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/javaee/run/localRun/ScriptUtil", "createCommandLine"));
        }
        return new GeneralCommandLine(parameters);
    }
}

