/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsPluginCondition;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.GrailsVersionCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.util.FieldInitializerTailTypes;

public class GrailsStaticFieldCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Map<GrailsArtifact, Trinity<String, TailType, Condition<PsiClass>>[]> ALLOWED_STATIC_FIELDS = GrailsUtils.createEnumMap(new Object[]{GrailsArtifact.DOMAIN, new Trinity[]{new Trinity((Object)"mapWith", (Object)FieldInitializerTailTypes.EQ_STRING, null), new Trinity((Object)"hasMany", (Object)FieldInitializerTailTypes.EQ_ARRAY, null), new Trinity((Object)"hasOne", (Object)FieldInitializerTailTypes.EQ_ARRAY, null), new Trinity((Object)"belongsTo", (Object)FieldInitializerTailTypes.EQ_ARRAY, null), new Trinity((Object)"relatesToMany", (Object)FieldInitializerTailTypes.EQ_ARRAY, null), new Trinity((Object)"constraints", (Object)FieldInitializerTailTypes.EQ_CLOSURE, null), new Trinity((Object)"mappedBy", (Object)FieldInitializerTailTypes.EQ_ARRAY, null), new Trinity((Object)"mapping", (Object)FieldInitializerTailTypes.EQ_CLOSURE, null), new Trinity((Object)"embedded", (Object)FieldInitializerTailTypes.EQ_STRING_ARRAY, null), new Trinity((Object)"transients", (Object)FieldInitializerTailTypes.EQ_STRING_ARRAY, null), new Trinity((Object)"evanescent", (Object)FieldInitializerTailTypes.EQ_STRING_ARRAY, null), new Trinity((Object)"optionals", (Object)TailType.EQ, null), new Trinity((Object)"namedQueries", (Object)FieldInitializerTailTypes.EQ_CLOSURE, null), new Trinity((Object)"fetchMode", (Object)FieldInitializerTailTypes.EQ_ARRAY, null), new Trinity((Object)"searchable", (Object)TailType.EQ, (Object)new GrailsPluginCondition("searchable")), new Trinity((Object)"auditable", (Object)TailType.EQ, (Object)new GrailsPluginCondition("audit-logging"))}, GrailsArtifact.JOB, new Trinity[]{new Trinity((Object)"triggers", (Object)FieldInitializerTailTypes.EQ_CLOSURE, null)}, GrailsArtifact.CONTROLLER, new Trinity[]{new Trinity((Object)"layout", (Object)FieldInitializerTailTypes.EQ_STRING, null), new Trinity((Object)"defaultAction", (Object)FieldInitializerTailTypes.EQ_STRING, null), new Trinity((Object)"allowedMethods", (Object)TailType.EQ, null), new Trinity((Object)"accessControl", (Object)FieldInitializerTailTypes.EQ_CLOSURE, (Object)Conditions.or((Condition)new GrailsPluginCondition("shiro"), (Condition)new GrailsPluginCondition("jsecurity"))), new Trinity((Object)"namespace", (Object)FieldInitializerTailTypes.EQ_STRING, (Object)new GrailsVersionCondition("2.3.0"))}, GrailsArtifact.TAGLIB, new Trinity[]{new Trinity((Object)"namespace", (Object)FieldInitializerTailTypes.EQ_STRING, null), new Trinity((Object)"supportsController", (Object)TailType.EQ, null), new Trinity((Object)"returnObjectForTags", (Object)FieldInitializerTailTypes.EQ_STRING_ARRAY, null)}, GrailsArtifact.SERVICE, new Trinity[]{new Trinity((Object)"transactional", (Object)TailType.EQ, null), new Trinity((Object)"scope", (Object)TailType.EQ, null)}, GrailsArtifact.URLMAPPINGS, new Trinity[]{new Trinity((Object)"mappings", (Object)FieldInitializerTailTypes.EQ_CLOSURE, null)}, GrailsArtifact.REALM, new Trinity[]{new Trinity((Object)"authTokenClass", (Object)TailType.EQ, null)}});
    private static final Map<GrailsArtifact, Trinity<String, TailType, Condition<PsiClass>>[]> ALLOWED_FIELDS = GrailsUtils.createEnumMap(new Object[]{GrailsArtifact.CONTROLLER, new Trinity[]{new Trinity((Object)"beforeInterceptor", (Object)TailType.EQ, null), new Trinity((Object)"afterInterceptor", (Object)TailType.EQ, null), new Trinity((Object)"scaffold", (Object)TailType.EQ, null)}, GrailsArtifact.FILTER, new Trinity[]{new Trinity((Object)"filters", (Object)TailType.EQ, null), new Trinity((Object)"dependsOn", (Object)TailType.EQ, null)}, GrailsArtifact.JOB, new Trinity[]{new Trinity((Object)"sessionRequired", (Object)TailType.EQ, null), new Trinity((Object)"concurrent", (Object)TailType.EQ, null)}});
    private static final Set<String> ourFieldNameCache;
    private final Map<GrailsArtifact, Trinity<String, TailType, Condition<PsiClass>>[]> myMap;

    public GrailsStaticFieldCompletionProvider(boolean aStatic) {
        this.myMap = aStatic ? ALLOWED_STATIC_FIELDS : ALLOWED_FIELDS;
    }

    public static boolean isGrailsField(@NotNull GrField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/grails/GrailsStaticFieldCompletionProvider", "isGrailsField"));
        }
        String fieldName = field.getName();
        if (!ourFieldNameCache.contains(fieldName)) {
            return false;
        }
        PsiClass containingClass = field.getContainingClass();
        GrailsArtifact grailsArtifact = GrailsArtifact.getType(containingClass);
        if (grailsArtifact == null) {
            return false;
        }
        Map<GrailsArtifact, Trinity<String, TailType, Condition<PsiClass>>[]> map2 = field.hasModifierProperty("static") ? ALLOWED_STATIC_FIELDS : ALLOWED_FIELDS;
        Trinity<String, TailType, Condition<PsiClass>>[] trinities = map2.get((Object)grailsArtifact);
        if (trinities == null) {
            return false;
        }
        for (Trinity<String, TailType, Condition<PsiClass>> trinity : trinities) {
            if (!((String)trinity.first).equals(fieldName) || trinity.third != null && !((Condition)trinity.third).value((Object)containingClass)) continue;
            return true;
        }
        return false;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/grails/GrailsStaticFieldCompletionProvider", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/grails/GrailsStaticFieldCompletionProvider", "addCompletions"));
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiClass.class);
        if (psiClass == null) {
            return;
        }
        GrailsArtifact artifact = GrailsUtils.calculateArtifactType(psiClass);
        if (artifact == null) {
            return;
        }
        Trinity<String, TailType, Condition<PsiClass>>[] allowedFields = this.myMap.get((Object)artifact);
        if (allowedFields == null) {
            return;
        }
        for (Trinity<String, TailType, Condition<PsiClass>> trinity : allowedFields) {
            String fieldName = (String)trinity.first;
            if (psiClass.findFieldByName(fieldName, false) != null || trinity.third != null && !((Condition)trinity.third).value((Object)psiClass)) continue;
            result2.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)fieldName), (TailType)((TailType)trinity.second)));
        }
    }

    static {
        HashSet<String> res = new HashSet<String>();
        for (Trinity<String, TailType, Condition<PsiClass>>[] trinities : ALLOWED_FIELDS.values()) {
            for (Trinity<String, TailType, Condition<PsiClass>> trinity : trinities) {
                res.add((String)trinity.first);
            }
        }
        for (Trinity<String, TailType, Condition<PsiClass>>[] trinities : ALLOWED_STATIC_FIELDS.values()) {
            for (Trinity<String, TailType, Condition<PsiClass>> trinity : trinities) {
                res.add((String)trinity.first);
            }
        }
        ourFieldNameCache = res;
    }
}

