/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GrailsGotoRelatedProvider
extends GotoRelatedProvider {
    public static final String GRAILS_GROUP = "Grails";
    public static final String GRAILS_VIEWS_GROUP = "Grails Views";

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        GrTypeDefinition artifactClass;
        GrailsArtifact artifact;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getItems"));
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
        if (module == null || !GrailsFramework.getInstance().hasSupport(module)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        ArrayList<GotoRelatedItem> res = new ArrayList<GotoRelatedItem>();
        if (containingFile.getViewProvider() instanceof GspFileViewProvider) {
            GrailsGotoRelatedProvider.getRelatedForGsp(module, containingFile, virtualFile, res);
        } else if (containingFile instanceof GroovyFile && (artifact = GrailsArtifact.getType((PsiClass)(artifactClass = GroovyUtils.getClassDefinition((GroovyFile)((GroovyFile)containingFile))))) != null) {
            String name = artifact.getArtifactName((PsiClass)artifactClass);
            if (artifact == GrailsArtifact.CONTROLLER) {
                GrailsGotoRelatedProvider.addAll(module, name, GrailsArtifact.DOMAIN, res);
                GrailsGotoRelatedProvider.addAllRelatedView((PsiClass)artifactClass, res);
            } else if (artifact == GrailsArtifact.DOMAIN) {
                Collection<GrClassDefinition> controllers = GrailsGotoRelatedProvider.addAll(module, name, GrailsArtifact.CONTROLLER, res);
                for (GrClassDefinition controller : controllers) {
                    GrailsGotoRelatedProvider.addAllRelatedView((PsiClass)controller, res);
                }
            }
        }
        ArrayList<GotoRelatedItem> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getItems"));
        }
        return arrayList;
    }

    private static void getRelatedForGsp(@NotNull Module module, @NotNull PsiFile file, @NotNull VirtualFile gspFile, List<GotoRelatedItem> res) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getRelatedForGsp"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getRelatedForGsp"));
        }
        if (gspFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspFile", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getRelatedForGsp"));
        }
        String templateName = GrailsUtils.getTemplateName(gspFile.getName());
        if (templateName != null) {
            GrailsGotoRelatedProvider.getRelatedForTemplate(file, res);
            return;
        }
        String name = GrailsUtils.getControllerNameByGsp(gspFile);
        if (name != null) {
            GrailsGotoRelatedProvider.addAll(module, name, GrailsArtifact.DOMAIN, res);
            Collection<GrClassDefinition> controllers = GrailsGotoRelatedProvider.addAll(module, name, GrailsArtifact.CONTROLLER, res);
            PsiMethod action = GrailsUtils.getControllerActions(name, module).get(gspFile.getNameWithoutExtension());
            if (action != null) {
                res.add(new GotoRelatedItem((PsiElement)GrailsUtils.toField(action), GRAILS_GROUP){

                    @Nullable
                    public Icon getCustomIcon() {
                        return JetgroovyIcons.Mvc.Action_method;
                    }
                });
            }
            for (GrClassDefinition controller : controllers) {
                GrailsGotoRelatedProvider.addAllRelatedView((PsiClass)controller, res);
            }
        }
    }

    private static void addAllRelatedView(@NotNull PsiClass controller, List<GotoRelatedItem> res) {
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "addAllRelatedView"));
        }
        VirtualFile gspDir = GrailsUtils.getControllerGspDir(controller);
        if (gspDir == null) {
            return;
        }
        PsiManager psiManager = controller.getManager();
        for (VirtualFile child : gspDir.getChildren()) {
            PsiFile psiFile;
            FileType fileType = child.getFileType();
            if (fileType != GspFileType.GSP_FILE_TYPE && fileType != StdFileTypes.JSP && fileType != StdFileTypes.JSPX || (psiFile = psiManager.findFile(child)) == null) continue;
            res.add(new GotoRelatedItem((PsiElement)psiFile, GRAILS_VIEWS_GROUP));
        }
    }

    private static Collection<GrClassDefinition> addAll(Module module, String name, GrailsArtifact artifact, List<GotoRelatedItem> res) {
        Collection<GrClassDefinition> instances = artifact.getInstances(module, name);
        for (GrClassDefinition aClass : instances) {
            res.add(new GotoRelatedItem((PsiElement)aClass, GRAILS_GROUP));
        }
        return instances;
    }

    private static void getRelatedForTemplate(@NotNull PsiFile gspFile, List<GotoRelatedItem> res) {
        if (gspFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspFile", "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider", "getRelatedForTemplate"));
        }
    }
}

