/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.PerspectiveFileEditorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.perspectives.DomainClassesRelationsEditor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class DomainClassesRelationsEditorProvider
extends PerspectiveFileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/perspectives/DomainClassesRelationsEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/perspectives/DomainClassesRelationsEditorProvider", "accept"));
        }
        if (!file.isValid()) {
            return false;
        }
        if (Registry.is((String)"grails.advanced.mode")) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof GroovyFile)) {
            return false;
        }
        for (GrTypeDefinition grTypeDefinition : ((GroovyFile)psiFile).getTypeDefinitions()) {
            if (!GormUtils.isGormBean((PsiClass)grTypeDefinition)) continue;
            return true;
        }
        return false;
    }

    public boolean isDumbAware() {
        return false;
    }

    @NotNull
    public PerspectiveFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/perspectives/DomainClassesRelationsEditorProvider", "createEditor"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/plugins/grails/perspectives/DomainClassesRelationsEditorProvider", "createEditor"));
        }
        DomainClassesRelationsEditor domainClassesRelationsEditor = new DomainClassesRelationsEditor(project, virtualFile);
        if (domainClassesRelationsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/DomainClassesRelationsEditorProvider", "createEditor"));
        }
        return domainClassesRelationsEditor;
    }
}

