/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives.graph;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;

public class DomainClassRelationsInfo {
    public static final String UNKNOWN_NAME = "unknown";
    public static final String BELONGS_TO_NAME = "belongsTo";
    public static final String HAS_MANY_NAME = "hasMany";
    public static final String RELATES_TO_MANY_NAME = "relatesToMany";
    public static final String HAS_ONE_NAME = "hasOne";
    public static final String TRANSIENTS_NAME = "transients";
    public static final String CONSTRAINTS_NAME = "constraints";
    public static final String MAPPED_BY = "mappedBy";
    private final DomainClassNode mySource;
    private final DomainClassNode myTarget;
    private Relation myRelation;
    @Nullable
    private String myVarName;

    public DomainClassRelationsInfo(DomainClassNode source, DomainClassNode target, Relation relation) {
        this.mySource = source;
        this.myTarget = target;
        this.myRelation = relation;
    }

    @NotNull
    public DomainClassNode getSource() {
        DomainClassNode domainClassNode = this.mySource;
        if (domainClassNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassRelationsInfo", "getSource"));
        }
        return domainClassNode;
    }

    @NotNull
    public DomainClassNode getTarget() {
        DomainClassNode domainClassNode = this.myTarget;
        if (domainClassNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassRelationsInfo", "getTarget"));
        }
        return domainClassNode;
    }

    public Relation getRelation() {
        return this.myRelation;
    }

    public void setRelation(Relation relation) {
        this.myRelation = relation;
    }

    @NotNull
    public String getEdgeLabel() {
        String label = "";
        switch (this.myRelation) {
            case UNKNOWN: 
            case DOUBLESTRONG: {
                label = GrailsBundle.message("domain.classes.relations.strong.strong", new Object[0]);
                break;
            }
            case STRONG: {
                label = GrailsBundle.message("domain.classes.relations.strong", new Object[0]);
                break;
            }
            case BELONGS_TO: {
                label = GrailsBundle.message("domain.classes.relations.belongs.to", new Object[0]);
                break;
            }
            case HAS_MANY: {
                label = GrailsBundle.message("domain.classes.relations.has.many", new Object[0]);
                break;
            }
            case MANY_TO_MANY: {
                label = GrailsBundle.message("domain.classes.relations.has.many.to.many", new Object[0]);
            }
        }
        String string = label;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassRelationsInfo", "getEdgeLabel"));
        }
        return string;
    }

    public void setVarName(@Nullable String varName) {
        this.myVarName = varName;
    }

    public boolean equals(Object otherDomainClssRelatiionInfo) {
        if (this == otherDomainClssRelatiionInfo) {
            return true;
        }
        if (otherDomainClssRelatiionInfo == null || this.getClass() != otherDomainClssRelatiionInfo.getClass()) {
            return false;
        }
        DomainClassRelationsInfo that = (DomainClassRelationsInfo)otherDomainClssRelatiionInfo;
        if (this.myRelation != that.getRelation()) {
            return false;
        }
        if (!this.mySource.equals(that.mySource)) {
            return false;
        }
        if (!this.myTarget.equals(that.myTarget)) {
            return false;
        }
        return this.myVarName == null || this.myVarName.equals(that.myVarName);
    }

    public int hashCode() {
        int result2 = this.mySource.hashCode();
        result2 = 31 * result2 + this.myTarget.hashCode();
        result2 = 31 * result2 + this.myRelation.hashCode();
        return result2;
    }

    @Nullable
    public String getVarName() {
        return this.myVarName;
    }

    public static enum Relation {
        UNKNOWN,
        BELONGS_TO,
        HAS_MANY,
        STRONG,
        DOUBLESTRONG,
        MANY_TO_MANY;

    }
}

