/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GspImportListReferenceProvider
extends JavaClassReferenceProvider {
    @NonNls
    private static final String STATIC_PREFIX = "static ";

    public GspImportListReferenceProvider() {
        THashMap options = new THashMap();
        options.put(RESOLVE_QUALIFIED_CLASS_NAME, Boolean.TRUE);
        options.put(ADVANCED_RESOLVE, Boolean.TRUE);
        this.setOptions((Map)options);
    }

    @NotNull
    public PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/grails/references/providers/GspImportListReferenceProvider", "getReferencesByString"));
        }
        ArrayList<JavaClassReference> results = new ArrayList<JavaClassReference>();
        int lastReferencePosition = 0;
        do {
            JavaClassReference[] allReferences;
            int asIndex = str.indexOf(" as ", lastReferencePosition);
            int i = str.indexOf(59, lastReferencePosition);
            int nextReferenceStart = i >= 0 ? i : str.length();
            String identifier = str.substring(lastReferencePosition, asIndex >= 0 && asIndex + 1 < nextReferenceStart ? asIndex + 1 : nextReferenceStart);
            if (identifier.length() == 0) {
                lastReferencePosition = nextReferenceStart + 1;
                continue;
            }
            int whitespaceShift = 0;
            while (whitespaceShift < identifier.length() && Character.isWhitespace(identifier.charAt(whitespaceShift++))) {
            }
            lastReferencePosition += whitespaceShift - 1;
            identifier = identifier.substring(whitespaceShift - 1);
            boolean isStatic = false;
            if (identifier.startsWith(STATIC_PREFIX)) {
                identifier = identifier.substring(STATIC_PREFIX.length());
                lastReferencePosition += STATIC_PREFIX.length();
                isStatic = true;
            }
            JavaClassReferenceSet referenceSet = new JavaClassReferenceSet(identifier.trim(), position, offsetInPosition + lastReferencePosition, isStatic, (JavaClassReferenceProvider)this);
            for (JavaClassReference allReference : allReferences = referenceSet.getAllReferences()) {
                String text = allReference.getCanonicalText();
                if ("*".equals(text)) continue;
                results.add(allReference);
            }
            lastReferencePosition = nextReferenceStart + 1;
        } while (lastReferencePosition < str.length());
        PsiReference[] psiReferenceArray = results.toArray(new PsiReference[results.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/providers/GspImportListReferenceProvider", "getReferencesByString"));
        }
        return psiReferenceArray;
    }

    public boolean isSoft() {
        return false;
    }
}

