/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.TagLibNamespaceDescriptor;
import org.jetbrains.plugins.grails.references.GrailsMethodNamedArgumentReferenceProvider;
import org.jetbrains.plugins.grails.references.common.GroovyGspTagWrapper;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;

public abstract class TagAttributeReferenceProvider
extends GrailsMethodNamedArgumentReferenceProvider.Contributor.Provider {
    private final String myAttributeName;
    private final String myNamespacePrefix;
    private final String[] myTagNames;

    protected TagAttributeReferenceProvider(@NotNull String attributeName, @Nullable String namespacePrefix, @Nullable String[] tagNames) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/jetbrains/plugins/grails/references/tagSupport/TagAttributeReferenceProvider", "<init>"));
        }
        this.myAttributeName = attributeName;
        this.myNamespacePrefix = namespacePrefix;
        this.myTagNames = tagNames;
    }

    public String getAttributeName() {
        return this.myAttributeName;
    }

    @Nullable
    public String getPrefix() {
        return this.myNamespacePrefix;
    }

    @Nullable
    public String[] getTagNames() {
        return this.myTagNames;
    }

    @NotNull
    public abstract PsiReference[] getReferencesByElement(@NotNull PsiElement var1, @NotNull String var2, int var3, @NotNull GspTagWrapper var4);

    @Override
    public final PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrNamedArgument namedArgument, @NotNull GroovyResolveResult resolveResult) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/TagAttributeReferenceProvider", "createRef"));
        }
        if (namedArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/grails/references/tagSupport/TagAttributeReferenceProvider", "createRef"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/tagSupport/TagAttributeReferenceProvider", "createRef"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        TagLibNamespaceDescriptor.GspTagMethod tagMethod = (TagLibNamespaceDescriptor.GspTagMethod)resolveResult.getElement();
        assert (tagMethod != null);
        if (this.myNamespacePrefix != null && !this.myNamespacePrefix.equals(tagMethod.getNamespacePrefix())) {
            return PsiReference.EMPTY_ARRAY;
        }
        return this.getReferencesByElement(element, text, offset, new GroovyGspTagWrapper((GrNamedArgumentsOwner)namedArgument.getParent(), tagMethod));
    }
}

