/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.sync;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.structure.Grails3Application;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationListener;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcUpgradeAction;

public class GrailsOldSdkSynchronizer
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsOldSdkSynchronizer", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        project.getMessageBus().connect().subscribe(GrailsApplicationListener.TOPIC, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsOldSdkSynchronizer", "lambda$runActivity$5"));
            }
            Collection<GrailsApplication> applications = GrailsApplicationManager.getInstance(project).getApplications();
            applications.stream().filter(application -> GrailsSDKManager.getGrailsSdk(application) == null && application instanceof OldGrailsApplication).forEach(application -> {
                Module module = ((OldGrailsApplication)application).getModule();
                VirtualFile sdkRoot = GrailsConfigUtils.getSDKInstallPath(module);
                if (sdkRoot != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                        MvcUpgradeAction.removeOldMvcSdk((MvcFramework)GrailsFramework.getInstance(), (ModifiableRootModel)model);
                        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)model).commit());
                        GrailsSDKManager.setGrailsSDK(application, sdkRoot.getPath());
                    }, application.getDisposed());
                }
            });
            String savedPath = PropertiesComponent.getInstance((Project)project).getValue("grails.sdk.home");
            if (savedPath != null) {
                applications.stream().filter(application -> GrailsSDKManager.getGrailsSdk(application) == null && application instanceof Grails3Application).forEach(application -> GrailsSDKManager.setGrailsSDK(application, savedPath));
                PropertiesComponent.getInstance((Project)project).setValue("grails.sdk.home", null);
            }
            project.getMessageBus().connect().disconnect();
        });
    }
}

