/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelegateReference
extends PsiReferenceBase<PsiElement> {
    private volatile boolean myDelegateInit;
    private volatile PsiReference myDelegate;
    private Boolean mySoft;

    public DelegateReference(PsiElement element, TextRange range) {
        super(element, range);
    }

    public DelegateReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/DelegateReference", "<init>"));
        }
        super(element);
    }

    public DelegateReference(@NotNull PsiElement element, boolean isSoft) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/DelegateReference", "<init>"));
        }
        super(element);
        this.mySoft = isSoft;
    }

    @Nullable
    protected abstract PsiReference createDelegate();

    private void ensureInit() {
        if (this.myDelegateInit) {
            return;
        }
        this.myDelegate = this.createDelegate();
        this.myDelegateInit = true;
    }

    public PsiElement resolve() {
        this.ensureInit();
        return this.myDelegate == null ? null : this.myDelegate.resolve();
    }

    @NotNull
    public Object[] getVariants() {
        this.ensureInit();
        Object[] objectArray = this.myDelegate == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : this.myDelegate.getVariants();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/DelegateReference", "getVariants"));
        }
        return objectArray;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.ensureInit();
        return this.myDelegate == null ? this.myElement : this.myDelegate.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/DelegateReference", "bindToElement"));
        }
        this.ensureInit();
        return this.myDelegate == null ? this.myElement : this.myDelegate.bindToElement(element);
    }

    public boolean isReferenceTo(PsiElement element) {
        this.ensureInit();
        return this.myDelegate != null && this.myDelegate.isReferenceTo(element);
    }

    public boolean isSoft() {
        if (this.mySoft != null) {
            return this.mySoft;
        }
        this.ensureInit();
        return this.myDelegate == null || this.myDelegate.isSoft();
    }
}

