/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MvcPluginDescriptor {
    public static final MvcPluginDescriptor[] EMPTY_ARRAY = new MvcPluginDescriptor[0];
    private final String myName;
    private Release myLastRelease;
    private final List<Release> releases;

    public MvcPluginDescriptor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginDescriptor", "<init>"));
        }
        this.releases = new ArrayList<Release>();
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public Release getLastRelease() {
        return this.myLastRelease;
    }

    public void setLastRelease(Release lastRelease) {
        this.myLastRelease = lastRelease;
    }

    public List<Release> getReleases() {
        return this.releases;
    }

    @Nullable
    public String getLatestVersion() {
        return this.myLastRelease == null ? null : this.myLastRelease.getVersion();
    }

    @Nullable
    public String getTitle() {
        return this.myLastRelease == null ? null : this.myLastRelease.getTitle();
    }

    public String toString() {
        return this.myName;
    }

    public static class Release {
        private final MvcPluginDescriptor myPlugin;
        private final String myVersion;
        private final String myType;
        private final String myTitle;
        private final String myAuthor;
        private final String myDescription;
        private final String myEmail;
        private final String myZipRelease;
        private final String myDocumentation;

        public Release(MvcPluginDescriptor plugin, String version, String type, String title, String author, String description, String email, String zipRelease, String documentation) {
            this.myPlugin = plugin;
            this.myTitle = title;
            this.myType = type;
            this.myVersion = version;
            this.myAuthor = author;
            this.myDescription = description;
            this.myEmail = email;
            this.myZipRelease = zipRelease;
            this.myDocumentation = documentation;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public String getAuthor() {
            return this.myAuthor;
        }

        public String getDescription() {
            return this.myDescription;
        }

        public String getEmail() {
            return this.myEmail;
        }

        public String getZipRelease() {
            return this.myZipRelease;
        }

        public String getDocumentation() {
            return this.myDocumentation;
        }

        public String getVersion() {
            return this.myVersion;
        }

        public String getType() {
            return this.myType;
        }

        public MvcPluginDescriptor getPlugin() {
            return this.myPlugin;
        }
    }
}

