/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.model.messaging;

import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.websocket.jam.SpringMessageMapping;
import com.intellij.spring.websocket.jam.SpringMessagingJamModel;
import com.intellij.spring.websocket.jam.SpringMessagingUrlAnnotation;
import com.intellij.spring.websocket.jam.SpringSendTo;
import com.intellij.spring.websocket.jam.SpringSendToUser;
import com.intellij.spring.websocket.model.messaging.SpringMessagingMethodUrlDefinition;
import com.intellij.spring.websocket.model.messaging.SpringMessagingModel;
import com.intellij.spring.websocket.model.messaging.SpringMessagingType;
import com.intellij.spring.websocket.model.messaging.SpringMessagingUrlDefinition;
import com.intellij.spring.websocket.model.messaging.SpringWebSocketPrefixes;
import com.intellij.spring.websocket.model.messaging.UrlPointer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UrlCollector
extends NotNullLazyValue<MultiMap<SpringMessagingType, SpringMessagingModel.Variant>> {
    private static final String DEFAULT_DESTINATION_PREFIX = "/topic";
    private static final String SIMP_MESSAGE_SENDING_OPERATIONS = "org.springframework.messaging.simp.SimpMessageSendingOperations";
    private static final String SEND_TO_USER_METHOD = "convertAndSendToUser";
    private static final String SEND_TO_METHOD = "convertAndSend";
    @NotNull
    private final Module myModule;
    private SpringWebSocketPrefixes myPrefixes;

    public UrlCollector(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/model/messaging/UrlCollector", "<init>"));
        }
        this.myModule = module;
    }

    @NotNull
    protected MultiMap<SpringMessagingType, SpringMessagingModel.Variant> compute() {
        this.myPrefixes = new SpringWebSocketPrefixes(this.myModule);
        MultiMap result = new MultiMap();
        ArrayList<SpringMessagingUrlDefinition> urlDefinitions = new ArrayList<SpringMessagingUrlDefinition>();
        urlDefinitions.addAll(SpringMessagingJamModel.getModel(this.myModule.getProject()).getMessageMappings(this.myModule));
        urlDefinitions.addAll(SpringMessagingJamModel.getModel(this.myModule.getProject()).getSubscribeMappings(this.myModule));
        urlDefinitions.addAll(SpringMessagingJamModel.getModel(this.myModule.getProject()).getSendTos(this.myModule));
        urlDefinitions.addAll(SpringMessagingJamModel.getModel(this.myModule.getProject()).getSendToUsers(this.myModule));
        urlDefinitions.addAll(this.getMethodUrlDefinitions());
        for (SpringMessagingUrlDefinition messagingUrlDefinition : urlDefinitions) {
            SpringMessagingType messagingType = messagingUrlDefinition.getMessagingType();
            if (messagingType == null) continue;
            SpringMessageMapping.ClassMapping classMapping = messagingUrlDefinition.getClassMapping();
            List<UrlPointer> urlPointers = messagingUrlDefinition.getUrlPointers();
            for (UrlPointer urlDefinitionPointer : urlPointers) {
                if (classMapping != null && messagingType.isAffectedByClassAnnotation) {
                    this.processClassMapping((MultiMap<SpringMessagingType, SpringMessagingModel.Variant>)result, messagingUrlDefinition, classMapping, urlDefinitionPointer);
                    continue;
                }
                this.addUrl((MultiMap<SpringMessagingType, SpringMessagingModel.Variant>)result, messagingUrlDefinition, urlDefinitionPointer, null);
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/model/messaging/UrlCollector", "compute"));
        }
        return multiMap;
    }

    private List<SpringMessagingUrlDefinition> getMethodUrlDefinitions() {
        PsiClass simpClass = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)SIMP_MESSAGE_SENDING_OPERATIONS);
        if (simpClass == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        SmartList result = new SmartList();
        UrlCollector.addSendTos((List<SpringMessagingUrlDefinition>)result, searchScope, simpClass, SEND_TO_USER_METHOD, SpringMessagingType.SEND_TO_USER, 1);
        UrlCollector.addSendTos((List<SpringMessagingUrlDefinition>)result, searchScope, simpClass, SEND_TO_METHOD, SpringMessagingType.SEND_TO, 0);
        return result;
    }

    private static void addSendTos(List<SpringMessagingUrlDefinition> result, GlobalSearchScope searchScope, @NotNull PsiClass simpClass, @NotNull String methodName, @NotNull SpringMessagingType messagingType, int destinationParamIndex) {
        PsiMethod[] sendToUsers;
        if (simpClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpClass", "com/intellij/spring/websocket/model/messaging/UrlCollector", "addSendTos"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/websocket/model/messaging/UrlCollector", "addSendTos"));
        }
        if (messagingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagingType", "com/intellij/spring/websocket/model/messaging/UrlCollector", "addSendTos"));
        }
        for (PsiMethod sendToUser : sendToUsers = simpClass.findMethodsByName(methodName, true)) {
            PsiParameter[] parameters = sendToUser.getParameterList().getParameters();
            if (parameters.length < destinationParamIndex + 2) continue;
            MethodReferencesSearch.search((PsiMethod)sendToUser, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                if (messagingType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagingType", "com/intellij/spring/websocket/model/messaging/UrlCollector", "lambda$addSendTos$0"));
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMethodCallExpression.class);
                if (methodCallExpression != null) {
                    PsiExpression destinationArgument = methodCallExpression.getArgumentList().getExpressions()[destinationParamIndex];
                    result.add(new SpringMessagingMethodUrlDefinition(messagingType, (PsiElement)destinationArgument, StringUtil.unquoteString((String)destinationArgument.getText())));
                }
                return true;
            });
        }
    }

    private void addUrl(@NotNull MultiMap<SpringMessagingType, SpringMessagingModel.Variant> result, @NotNull SpringMessagingUrlDefinition messagingUrlDefinition, @NotNull UrlPointer urlDefinition, @Nullable UrlPointer classPrefix) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/websocket/model/messaging/UrlCollector", "addUrl"));
        }
        if (messagingUrlDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagingUrlDefinition", "com/intellij/spring/websocket/model/messaging/UrlCollector", "addUrl"));
        }
        if (urlDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDefinition", "com/intellij/spring/websocket/model/messaging/UrlCollector", "addUrl"));
        }
        SpringMessagingType messagingType = messagingUrlDefinition.getMessagingType();
        if (messagingType == null) {
            return;
        }
        for (UrlPointer prefix : this.myPrefixes.get(messagingType)) {
            result.putValue((Object)messagingType, (Object)new SpringMessagingModel.Variant(prefix, classPrefix, urlDefinition));
        }
        if (messagingUrlDefinition instanceof SpringMessageMapping.MethodMapping) {
            SpringMessageMapping.MethodMapping methodMapping = (SpringMessageMapping.MethodMapping)messagingUrlDefinition;
            SpringMessagingUrlAnnotation sendTo = (SpringMessagingUrlAnnotation)JamService.getJamService((Project)this.myModule.getProject()).getJamElement(methodMapping.getPsiElement(), new JamMemberMeta[]{SpringSendTo.META, SpringSendToUser.META});
            if (sendTo == null) {
                result.putValue((Object)SpringMessagingType.SEND_TO, (Object)new SpringMessagingModel.Variant(new UrlPointer(null, DEFAULT_DESTINATION_PREFIX), classPrefix, urlDefinition));
            }
        }
    }

    private void processClassMapping(@NotNull MultiMap<SpringMessagingType, SpringMessagingModel.Variant> result, @NotNull SpringMessagingUrlDefinition messagingUrlDefinition, @NotNull SpringMessageMapping.ClassMapping classMapping, @NotNull UrlPointer urlDefinition) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/websocket/model/messaging/UrlCollector", "processClassMapping"));
        }
        if (messagingUrlDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagingUrlDefinition", "com/intellij/spring/websocket/model/messaging/UrlCollector", "processClassMapping"));
        }
        if (classMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classMapping", "com/intellij/spring/websocket/model/messaging/UrlCollector", "processClassMapping"));
        }
        if (urlDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDefinition", "com/intellij/spring/websocket/model/messaging/UrlCollector", "processClassMapping"));
        }
        if (classMapping.getUrls().isEmpty()) {
            this.addUrl(result, messagingUrlDefinition, urlDefinition, null);
        } else {
            for (JamStringAttributeElement<String> classUrl : classMapping.getUrls()) {
                this.addUrl(result, messagingUrlDefinition, urlDefinition, new UrlPointer(classUrl));
            }
        }
    }
}

