/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.BaseInterpolator;
import com.android.internal.R;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper;

@HasNativeInterpolator
public class CycleInterpolator
extends BaseInterpolator
implements NativeInterpolatorFactory {
    private float mCycles;

    public CycleInterpolator(float cycles) {
        this.mCycles = cycles;
    }

    public CycleInterpolator(Context context, AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    public CycleInterpolator(Resources resources, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.CycleInterpolator, 0, 0) : resources.obtainAttributes(attrs, R.styleable.CycleInterpolator);
        this.mCycles = a.getFloat(0, 1.0f);
        this.setChangingConfiguration(a.getChangingConfigurations());
        a.recycle();
    }

    @Override
    public float getInterpolation(float input) {
        return (float)Math.sin((double)(2.0f * this.mCycles) * Math.PI * (double)input);
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactoryHelper.createCycleInterpolator(this.mCycles);
    }
}

