/*
 * Decompiled with CFR 0.152.
 */
package com.android.ninepatch;

import com.android.ninepatch.GraphicsUtilities;
import com.android.ninepatch.NinePatchChunk;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class NinePatch {
    public static final String EXTENSION_9PATCH = ".9.png";
    private BufferedImage mImage;
    private NinePatchChunk mChunk;

    public BufferedImage getImage() {
        return this.mImage;
    }

    public NinePatchChunk getChunk() {
        return this.mChunk;
    }

    public static NinePatch load(URL uRL, boolean bl) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = GraphicsUtilities.loadCompatibleImage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        boolean bl2 = uRL.getPath().toLowerCase().endsWith(EXTENSION_9PATCH);
        return NinePatch.load(bufferedImage, bl2, bl);
    }

    public static NinePatch load(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = GraphicsUtilities.loadCompatibleImage(inputStream);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return NinePatch.load(bufferedImage, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NinePatch load(BufferedImage bufferedImage, boolean bl, boolean bl2) {
        if (!bl) {
            if (!bl2) return null;
            bufferedImage = NinePatch.convertTo9Patch(bufferedImage);
            return new NinePatch(bufferedImage);
        } else {
            NinePatch.ensure9Patch(bufferedImage);
        }
        return new NinePatch(bufferedImage);
    }

    public int getWidth() {
        return this.mImage.getWidth();
    }

    public int getHeight() {
        return this.mImage.getHeight();
    }

    public boolean getPadding(int[] nArray) {
        this.mChunk.getPadding(nArray);
        return true;
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.mChunk.draw(this.mImage, graphics2D, n, n2, n3, n4, 0, 0);
    }

    private NinePatch(BufferedImage bufferedImage) {
        this.mChunk = NinePatchChunk.create(bufferedImage);
        this.mImage = this.extractBitmapContent(bufferedImage);
    }

    private static void ensure9Patch(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        for (n2 = 0; n2 < n3; ++n2) {
            n = bufferedImage.getRGB(n2, 0);
            if (n != 0 && n != -16777216) {
                bufferedImage.setRGB(n2, 0, 0);
            }
            if ((n = bufferedImage.getRGB(n2, n4 - 1)) == 0 || n == -16777216) continue;
            bufferedImage.setRGB(n2, n4 - 1, 0);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            n = bufferedImage.getRGB(0, n2);
            if (n != 0 && n != -16777216) {
                bufferedImage.setRGB(0, n2, 0);
            }
            if ((n = bufferedImage.getRGB(n3 - 1, n2)) == 0 || n == -16777216) continue;
            bufferedImage.setRGB(n3 - 1, n2, 0);
        }
    }

    private static BufferedImage convertTo9Patch(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = GraphicsUtilities.createTranslucentCompatibleImage(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 1, 1, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private BufferedImage extractBitmapContent(BufferedImage bufferedImage) {
        return bufferedImage.getSubimage(1, 1, bufferedImage.getWidth() - 2, bufferedImage.getHeight() - 2);
    }
}

