/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.LocalVsRemoteTaskBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompareLocalVsRemoteTask
extends LocalVsRemoteTaskBase<LocalMappingDiffRoot> {
    private static final Logger LOG = Logger.getInstance((String)LocalVsRemoteTaskBase.class.getName());

    public CompareLocalVsRemoteTask(@NotNull Project project, @NotNull String title, WebServerConfig server, String toolWindowId, LocalMappingDiffRoot root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/CompareLocalVsRemoteTask", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/CompareLocalVsRemoteTask", "<init>"));
        }
        super(project, title, server, toolWindowId, Collections.singletonList(root));
    }

    @Override
    protected boolean execute(List<DiffRoot> roots, ExecutionContextBase context, RemoteConnection remoteConnection) {
        DiffContent remoteContent;
        LOG.assertTrue(roots.size() == 1, (Object)"Compare action is designed for a single pair of files.");
        DiffRoot pair = roots.get(0);
        FileObject remoteItem = pair.getRemote();
        VirtualFile localFile = pair.getLocal();
        context.getProgressIndicator().setText(WDBundle.message("loading.content.of", remoteItem.getName().getBaseName()));
        String remotePath = context.getServer().getPresentablePath(remoteItem);
        try {
            byte[] remoteBytes = FileTransferUtil.getContent(remoteItem, context.getProgressIndicator());
            remoteContent = DiffContentFactory.getInstance().createFromBytes(this.getProject(), remoteBytes, localFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            String message = WDBundle.message("could.not.load.remote.file.content", remotePath, PublishUtils.getMessage(e, false));
            Util.showBalloonError(this.getProject(), this.myToolWindowId, message);
            return false;
        }
        context.getProgressIndicator().checkCanceled();
        ApplicationManager.getApplication().invokeLater(() -> {
            String title1 = WDBundle.message("diff.local", localFile.getPresentableUrl());
            String title2 = WDBundle.message("diff.deployed", remotePath);
            DiffContent localContent = DiffContentFactory.getInstance().create(this.getProject(), localFile);
            SimpleDiffRequest request = new SimpleDiffRequest(localFile.getPresentableUrl(), localContent, remoteContent, title1, title2);
            DiffManager.getInstance().showDiff(this.getProject(), (DiffRequest)request);
        });
        return true;
    }

    @Override
    @Nullable
    protected String validate(LocalMappingDiffRoot pair, FileObject remoteItem, ExecutionContextBase context) {
        try {
            if (!remoteItem.exists()) {
                return WDBundle.message(pair.getLocal().isDirectory() ? "remote.folder.does.not.exist" : "remote.file.does.not.exist", context.getServer().getPresentablePath(remoteItem));
            }
            if (remoteItem.getType() == (pair.getLocal().isDirectory() ? FileType.FILE : FileType.FOLDER)) {
                return WDBundle.message(remoteItem.getType() == FileType.FOLDER ? "remote.item.is.folder" : "remote.item.is.file", context.getServer().getPresentablePath(remoteItem));
            }
        }
        catch (FileSystemException e) {
            return PublishUtils.getMessage(e, false);
        }
        return null;
    }
}

