/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.RemoteHostTask;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalVsRemoteTaskBase<T extends LocalMappingDiffRoot>
extends RemoteHostTask {
    private static final Logger LOG = Logger.getInstance((String)LocalVsRemoteTaskBase.class.getName());
    protected final String myToolWindowId;
    private final List<T> myRoots;

    public LocalVsRemoteTaskBase(@NotNull Project project, @NotNull String title, WebServerConfig server, String toolWindowId, List<T> roots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/LocalVsRemoteTaskBase", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/LocalVsRemoteTaskBase", "<init>"));
        }
        super(project, ConnectionOwnerFactory.createConnectionOwner(project), server, PublishConfig.getInstance(project), title, true, ProjectDeploymentRevisionTracker.getInstance(project), DeploymentMode.CUSTOM);
        this.myToolWindowId = toolWindowId;
        this.myRoots = roots;
    }

    @Override
    protected boolean executeOperations(ExecutionContextBase context, RemoteConnection remoteConnection) {
        try {
            ArrayList<DiffRoot> files = new ArrayList<DiffRoot>(this.myRoots.size());
            ArrayList<String> warnings = new ArrayList<String>();
            for (LocalMappingDiffRoot root : this.myRoots) {
                DiffRoot rootData = this.getFullData(context, root);
                context.getProgressIndicator().checkCanceled();
                String warning = this.validate(root, rootData.getRemote(), context);
                if (warning != null) {
                    warnings.add(warning);
                    continue;
                }
                files.add(rootData);
            }
            if (files.isEmpty()) {
                this.showWarnings(warnings);
                return false;
            }
            this.showWarnings(warnings);
            return this.execute(files, context, remoteConnection);
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            Util.showBalloonError(this.getProject(), this.myToolWindowId, PublishUtils.getMessage(e, false));
            return false;
        }
    }

    @Nullable
    protected String validate(T root, FileObject remoteItem, ExecutionContextBase context) {
        return null;
    }

    private void showWarnings(List<String> warnings) {
        if (!warnings.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String warning : warnings) {
                sb.append(warning).append("\n");
            }
            Util.showBalloonWarning(this.getProject(), this.myToolWindowId, sb.toString());
        }
    }

    @Override
    protected void print(String text, ConsoleViewContentType contentType) {
    }

    protected abstract boolean execute(List<DiffRoot> var1, ExecutionContextBase var2, RemoteConnection var3);

    protected abstract DiffRoot getFullData(ExecutionContextBase var1, T var2) throws FileSystemException;
}

