/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.RemoteHostTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.OverwriteLocalWarningDialog;
import com.jetbrains.plugins.webDeployment.ui.OverwriteRemoteWarningDialog;
import com.jetbrains.plugins.webDeployment.ui.UiConstants;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransferTask
extends RemoteHostTask {
    private static final Logger LOG = Logger.getInstance((String)TransferTask.class.getName());
    private final boolean myIsServerSideModification;
    private final boolean myUpdateLocalHistory;
    protected final PublishConfig myPublishConfig;
    private final PublishConfig myOriginalConfig;
    private final boolean myCancellable;
    protected final Map<String, Integer> myProcessedCounters;
    protected int myTotalProcessed;
    protected int myFailed;
    private long myTotalSize;

    public TransferTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, WebServerConfig serverConfig, String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/TransferTask", "<init>"));
        }
        if (revisionTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionTracker", "com/jetbrains/plugins/webDeployment/TransferTask", "<init>"));
        }
        this(project, connectionOwner, serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker, DeploymentMode.CUSTOM);
    }

    public TransferTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, WebServerConfig serverConfig, String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker, DeploymentMode mode) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/TransferTask", "<init>"));
        }
        if (revisionTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionTracker", "com/jetbrains/plugins/webDeployment/TransferTask", "<init>"));
        }
        super(project, connectionOwner, serverConfig, publishConfig, title, background, revisionTracker, mode);
        this.myProcessedCounters = new TreeMap<String, Integer>((s1, s2) -> s1.compareToIgnoreCase((String)s2));
        this.myTotalProcessed = 0;
        this.myFailed = 0;
        this.myTotalSize = 0L;
        this.myIsServerSideModification = serverSideModification;
        this.myUpdateLocalHistory = updateLocalHistory;
        this.myOriginalConfig = publishConfig;
        this.myCancellable = cancellable;
        this.myPublishConfig = publishConfig.clone();
    }

    protected boolean isServerSideModification() {
        return this.myIsServerSideModification;
    }

    protected abstract boolean isMultipleOperations();

    protected abstract boolean prepareOperations(ExecutionContext var1) throws FileSystemException;

    @Nullable
    protected abstract TransferOperation getNextOperation();

    protected abstract int getDoneStepsNumber();

    protected abstract int getTotalStepsNumber();

    protected abstract void assertAllExecuted(int var1, int var2);

    @Override
    protected boolean executeOperations(final ExecutionContextBase contextBase, RemoteConnection connection) {
        TransferOperation operation;
        boolean notEmpty;
        ExecutionContext context;
        long startTime = System.currentTimeMillis();
        try {
            final FileObject remoteRoot = connection.resolveRoot();
            context = new ExecutionContext(){
                private boolean myIgnoreOverwriting;
                private OverwriteRemoteWarningDialog.OverwriteOption myOverwriteOption;

                @Override
                public PublishConfig getConfig() {
                    return TransferTask.this.myPublishConfig;
                }

                @Override
                public void incCounter(String counterTitle) {
                    Integer value = TransferTask.this.myProcessedCounters.get(counterTitle);
                    if (value == null) {
                        value = 1;
                    } else {
                        Integer n = value;
                        Integer n2 = value = Integer.valueOf(value + 1);
                    }
                    TransferTask.this.myProcessedCounters.put(counterTitle, value);
                    ++TransferTask.this.myTotalProcessed;
                }

                @Override
                public void incBytesTransmitted(long bytes) {
                    TransferTask.this.myTotalSize = TransferTask.this.myTotalSize + bytes;
                }

                @Override
                public void console(String message, ConsoleViewContentType type) {
                    TransferTask.this.print(message, type);
                }

                @Override
                public boolean isMultipleOperations() {
                    return TransferTask.this.isMultipleOperations();
                }

                @Override
                public void showBalloon(String message, MessageType type) {
                    TransferTask.this.showBalloon(type, message, false);
                }

                @Override
                public boolean promptForOverwrite(@Nullable FileObject source, @NotNull FileObject target) throws IOException {
                    if (target == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/TransferTask$1", "promptForOverwrite"));
                    }
                    if (this.myIgnoreOverwriting) {
                        return true;
                    }
                    if (this.isServerSideModification()) {
                        return this.promptForRemoteOverwrite(source, target);
                    }
                    this.promptForLocalOverwrite();
                    return true;
                }

                private void promptForLocalOverwrite() {
                    if (TransferTask.this.myDeploymentMode != DeploymentMode.CUSTOM || !TransferTask.this.myPublishConfig.isPromptOnLocalOverwrite()) {
                        return;
                    }
                    Ref cancelled = new Ref();
                    Runnable showDialog = () -> {
                        OverwriteLocalWarningDialog dialog = OverwriteLocalWarningDialog.createInstance(TransferTask.this.myConnectionOwner, TransferTask.this.myPublishConfig, this.getServer().getName(), TransferTask.this.myOriginalConfig);
                        if (dialog.isToBeShown()) {
                            dialog.show();
                            cancelled.set((Object)(!dialog.isOK() ? 1 : 0));
                        } else {
                            dialog.close(0);
                            cancelled.set((Object)false);
                        }
                    };
                    WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)showDialog);
                    if (((Boolean)cancelled.get()).booleanValue()) {
                        throw new ProcessCanceledException();
                    }
                    TransferTask.this.myPublishConfig.setPromptOnLocalOverwrite(false);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private boolean promptForRemoteOverwrite(FileObject source, FileObject target) throws IOException {
                    if (source == null) return true;
                    if (TransferTask.this.myPublishConfig.getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.NONE) return true;
                    if (this.getDeploymentMode() != DeploymentMode.CUSTOM) {
                        return true;
                    }
                    String previousText = this.getProgressIndicator().getText();
                    DeploymentRevisionTracker.Revision baseRevision = this.getRevisionTracker().getBaseRevision(DeploymentPathUtils.getLocalPath(source), this.getServer());
                    if (baseRevision == null) {
                        return true;
                    }
                    this.getProgressIndicator().setText(WDBundle.message("checking.remote.revision", target.getName().getBaseName()));
                    try {
                        byte[] currentRemoteContent;
                        long currentRemoteTimestamp;
                        boolean accurateTimestamp;
                        boolean bl = accurateTimestamp = this.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                        if (TransferTask.this.myPublishConfig.getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
                            currentRemoteTimestamp = target.getContent().getLastModifiedTime(accurateTimestamp);
                            if (TransferOperation.areTimestampsEqual(baseRevision.timestamp, currentRemoteTimestamp, target.getFileSystem().getLastModTimeAccuracy()) && target.getContent().getSize() == (long)baseRevision.content.length) {
                                boolean bl2 = true;
                                return bl2;
                            }
                            currentRemoteContent = FileTransferUtil.getContent(target, this.getProgressIndicator());
                        } else {
                            currentRemoteContent = FileTransferUtil.getContent(target, this.getProgressIndicator());
                            if (Arrays.equals(baseRevision.content, currentRemoteContent)) {
                                boolean bl3 = true;
                                return bl3;
                            }
                            currentRemoteTimestamp = target.getContent().getLastModifiedTime(accurateTimestamp);
                        }
                        Ref result1 = new Ref();
                        if (this.myOverwriteOption != null) {
                            result1.set((Object)this.myOverwriteOption);
                        } else {
                            Ref doNotAsk = new Ref((Object)false);
                            TransferTask.showUi(() -> {
                                OverwriteRemoteWarningDialog dialog = OverwriteRemoteWarningDialog.createInstance(TransferTask.this.myConnectionOwner, target, this.getServer(), true);
                                dialog.show();
                                result1.set((Object)dialog.getResult());
                                doNotAsk.set((Object)dialog.isRememberForUpload());
                            });
                            if (((Boolean)doNotAsk.get()).booleanValue()) {
                                this.myOverwriteOption = (OverwriteRemoteWarningDialog.OverwriteOption)((Object)result1.get());
                            }
                        }
                        switch ((OverwriteRemoteWarningDialog.OverwriteOption)((Object)result1.get())) {
                            case OVERWRITE: {
                                boolean doNotAsk = true;
                                return doNotAsk;
                            }
                            case SKIP: {
                                boolean doNotAsk = false;
                                return doNotAsk;
                            }
                            case MERGE: {
                                Ref result3;
                                DeploymentPathUtils.refreshRemoteFile(target, this);
                                long newTimestamp = target.getContent().getLastModifiedTime(accurateTimestamp);
                                if (!TransferOperation.areTimestampsEqual(newTimestamp, currentRemoteTimestamp, target.getFileSystem().getLastModTimeAccuracy()) || target.getContent().getSize() != (long)currentRemoteContent.length) {
                                    currentRemoteTimestamp = newTimestamp;
                                    currentRemoteContent = FileTransferUtil.getContent(target, this.getProgressIndicator());
                                }
                                VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(DeploymentPathUtils.getLocalPath(source));
                                LOG.assertTrue(localFile != null && !localFile.isDirectory(), (Object)("virtual file '" + source + "' is not part of VFS while uploading it"));
                                byte[] baseContent = baseRevision.content;
                                do {
                                    boolean merged;
                                    byte[] localContent = localFile.contentsToByteArray();
                                    byte[] remoteContent = currentRemoteContent;
                                    Ref successRef = new Ref();
                                    TransferTask.showUi(() -> {
                                        String windowTitle = WDBundle.message("merge.on.upload.title", localFile.getName(), this.getServer().getName());
                                        List titles = ContainerUtil.list((Object[])new String[]{WDBundle.message("merge.on.upload.local.version.title", localFile.getPresentableUrl()), WDBundle.message("merge.on.upload.result.title", new Object[0]), WDBundle.message("merge.on.upload.remote.version.title", this.getServer().getPresentablePath(target))});
                                        List contents = ContainerUtil.list((Object[])new byte[][]{localContent, baseContent, remoteContent});
                                        Consumer callback = result -> {
                                            Document document = FileDocumentManager.getInstance().getCachedDocument(localFile);
                                            if (document != null) {
                                                FileDocumentManager.getInstance().saveDocument(document);
                                            }
                                            successRef.set((Object)(result != MergeResult.CANCEL ? 1 : 0));
                                        };
                                        try {
                                            TextMergeRequest request = DiffRequestFactory.getInstance().createTextMergeRequest(TransferTask.this.myProject, localFile, contents, windowTitle, titles, callback);
                                            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE, (Object)Couple.of((Object)DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]), (Object)WDBundle.message("merge.dialog.cancel.prompt", localFile.getName())));
                                            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, PublishUtils.getMergeResolveCaptions());
                                            DiffManager.getInstance().showMerge(TransferTask.this.myProject, (MergeRequest)request);
                                        }
                                        catch (InvalidDiffRequestException e) {
                                            LOG.error((Throwable)e);
                                        }
                                    });
                                    boolean bl4 = merged = successRef.get() == Boolean.TRUE;
                                    if (!merged) {
                                        boolean bl5 = false;
                                        return bl5;
                                    }
                                    DeploymentPathUtils.refreshRemoteFile(target, this);
                                    newTimestamp = target.getContent().getLastModifiedTime(accurateTimestamp);
                                    if (TransferOperation.areTimestampsEqual(newTimestamp, currentRemoteTimestamp, target.getFileSystem().getLastModTimeAccuracy()) && target.getContent().getSize() == (long)currentRemoteContent.length) {
                                        boolean bl6 = true;
                                        return bl6;
                                    }
                                    currentRemoteTimestamp = newTimestamp;
                                    currentRemoteContent = FileTransferUtil.getContent(target, this.getProgressIndicator());
                                    result3 = new Ref();
                                    TransferTask.showUi(() -> result3.set((Object)TransferTask.showDialog(TransferTask.this.myConnectionOwner, WDBundle.message("merge.on.upload.file.changed.while.merge", localFile.getName(), this.getServer().getName()), WDBundle.message("merge.on.upload.title", localFile.getName(), this.getServer().getName()), new String[]{WDBundle.message("merge.again", new Object[0]), WDBundle.message("overwrite.remote.dialog.skip.action.name", new Object[0])})));
                                } while ((Integer)result3.get() != 1);
                                boolean bl7 = false;
                                return bl7;
                            }
                        }
                        LOG.error("Unexpected result: " + result1.get());
                        boolean bl8 = true;
                        return bl8;
                    }
                    finally {
                        this.getProgressIndicator().setText(previousText);
                    }
                }

                @Override
                public ProgressIndicator getProgressIndicator() {
                    return contextBase.getProgressIndicator();
                }

                @Override
                public void addAffectedRoot(FileName fileName, boolean remote) {
                    contextBase.addAffectedRoot(fileName, remote);
                }

                @Override
                public boolean isServerSideModification() {
                    return TransferTask.this.isServerSideModification();
                }

                @Override
                public WebServerConfig getServer() {
                    return contextBase.getServer();
                }

                public FileObject getTargetRoot() {
                    return remoteRoot;
                }

                @Override
                public FileObject findRemoteFile(WebServerConfig.RemotePath path, boolean refreshUpRecursively) throws FileSystemException {
                    return contextBase.findRemoteFile(path, refreshUpRecursively);
                }

                @Override
                public boolean isTolerateSetPermissionsErrors() {
                    return TransferTask.this.isTolerateSetPermissionsErrors();
                }

                @Override
                public Project getProject() {
                    return TransferTask.this.myProject;
                }

                @Override
                public boolean isCancellable() {
                    return TransferTask.this.myCancellable;
                }

                @Override
                public void scheduleForSelection(WebServerConfig.RemotePath remotePath, Object requestor) {
                    contextBase.scheduleForSelection(remotePath, requestor);
                }

                @Override
                public void setCurrentFileFraction(double fraction) {
                    assert (0.0 <= fraction);
                    assert (fraction <= 1.0);
                    this.getProgressIndicator().setFraction(((double)TransferTask.this.getDoneStepsNumber() + fraction) / (double)TransferTask.this.getTotalStepsNumber());
                }

                @Override
                public void setIgnoreOverwriting(boolean ignore) {
                    this.myIgnoreOverwriting = ignore;
                }

                @Override
                public DeploymentMode getDeploymentMode() {
                    return TransferTask.this.myDeploymentMode;
                }

                @Override
                public DeploymentRevisionTracker getRevisionTracker() {
                    return TransferTask.this.myRevisionTracker;
                }
            };
            context.getProgressIndicator().setText(WDBundle.message("collecting.files", new Object[0]));
            notEmpty = this.prepareOperations(context);
        }
        catch (FileSystemException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            LOG.warn((Throwable)e);
            String message = WDBundle.message("collect.files.failed", PublishUtils.getMessage(e, true));
            this.print(message, ConsoleViewContentType.ERROR_OUTPUT);
            this.showBalloon(MessageType.ERROR, message, true);
            return false;
        }
        if (!notEmpty) {
            this.printExcludedMessage();
            this.print(WDBundle.message("nothing.to.transfer", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
            this.showBalloon(MessageType.INFO, WDBundle.message("nothing.to.transfer", new Object[0]), true);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting " + (this.isServerSideModification() ? "server-side modification" : "local modification"));
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            LOG.debug("Publish config:\n" + outputter.outputString(XmlSerializer.serialize((Object)this.myPublishConfig.getState())));
            LOG.debug("Server config:\n" + outputter.outputString(XmlSerializer.serialize((Object)context.getServer().clone())));
        }
        if (this.myUpdateLocalHistory) {
            if (this.isServerSideModification()) {
                LocalHistory.getInstance().putSystemLabel(this.myProject, this.getTitle());
            } else {
                this.myLocalHistoryAction = LocalHistory.getInstance().startAction(this.getTitle());
            }
        }
        long uploadStartTime = System.currentTimeMillis();
        while ((operation = this.getNextOperation()) != null) {
            if (this.myCancellable) {
                context.getProgressIndicator().checkCanceled();
            }
            try {
                operation.prepare(context);
                context.getProgressIndicator().setText(operation.getProgressText(context));
                this.print(operation.getDetailedText(context), ConsoleViewContentType.NORMAL_OUTPUT);
                operation.execute(context);
                context.getProgressIndicator().setFraction(((double)this.getDoneStepsNumber() + 1.0) / (double)this.getTotalStepsNumber());
            }
            catch (FileSystemException e) {
                LOG.warn(operation + "failed", (Throwable)e);
                String text = operation.getErrorMessage(context, PublishUtils.getMessage(e, true));
                this.print(text, ConsoleViewContentType.ERROR_OUTPUT);
                if (!this.stopOnFirstError() && this.isMultipleOperations() && !PublishUtils.isFatal(e)) {
                    ++this.myFailed;
                    continue;
                }
                String shortText = operation.getErrorMessage(context, PublishUtils.getMessage(e, false));
                this.showBalloon(MessageType.ERROR, WDBundle.message("operation.failed", this.getTitle(), StringUtil.decapitalize((String)shortText)), true);
                return false;
            }
        }
        LOG.debug("finished");
        this.assertAllExecuted(this.myTotalProcessed, this.myFailed);
        long time = System.currentTimeMillis() - startTime + 1L;
        long uploadTime = System.currentTimeMillis() - uploadStartTime + 1L;
        this.printResultMessage(time, uploadTime);
        this.showBalloon(this.getResultMessageType(), this.getResultMessage(this.getTitle(), this.myProcessedCounters, this.myFailed, this.myTotalSize, time, uploadTime, false), true);
        return this.myTotalProcessed > 0;
    }

    protected boolean stopOnFirstError() {
        return this.myPublishConfig.isStopOnFirstError();
    }

    protected void printResultMessage(long time, long uploadTime) {
        this.print(this.getResultMessage(this.getTitle(), this.myProcessedCounters, this.myFailed, this.myTotalSize, time, uploadTime, true), ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    protected void printExcludedMessage() {
        Integer excluded = this.myProcessedCounters.get("transfer.details.excluded");
        if (excluded == null || excluded == 0) {
            return;
        }
        this.print(WDBundle.message("transfer.details.excluded", excluded, excluded), ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    protected MessageType getResultMessageType() {
        return this.myFailed == 0 ? MessageType.INFO : (this.myTotalProcessed > 0 ? MessageType.WARNING : MessageType.ERROR);
    }

    protected boolean isTolerateSetPermissionsErrors() {
        return false;
    }

    protected String getResultMessage(String title, Map<String, Integer> processed, int failed, long totalSize, long totalTime, long transferTime, boolean details) {
        return TransferTask.getResultMessageStatic(title, processed, failed, totalSize, totalTime, transferTime, details);
    }

    public static String getResultMessageStatic(String title, Map<String, Integer> processed, int failed, long totalSize, long totalTime, long transferTime, boolean details) {
        StringBuilder statistics = new StringBuilder();
        for (Map.Entry<String, Integer> entry : processed.entrySet()) {
            if (statistics.length() > 0) {
                statistics.append(", ");
            }
            statistics.append(WDBundle.message(entry.getKey(), entry.getValue(), entry.getValue() > 1 ? 2 : 1));
        }
        if (failed > 0) {
            if (statistics.length() > 0) {
                statistics.append(", ");
            }
            statistics.append(WDBundle.message("transfer.details.failed", TransferTask.getItemsMessage(failed)));
        }
        if (statistics.length() > 0) {
            statistics.insert(0, ": ");
        }
        StringBuilder sb = new StringBuilder();
        if (details) {
            sb.append(WDBundle.message("operation.finished.in", title, DateFormatUtil.formatDuration((long)totalTime), statistics));
        } else {
            sb.append(WDBundle.message("operation.finished", title, statistics));
        }
        if (details && totalSize > 0L) {
            float bps = (float)totalSize / (float)transferTime * 1000.0f;
            sb.append(UiConstants.formatSize(bps, "transfer.bps", "transfer.kbps", "transfer.mbps"));
        }
        return sb.toString();
    }

    private static void showUi(Runnable r) {
        try {
            GuiUtils.runOrInvokeAndWait((Runnable)r);
        }
        catch (InvocationTargetException e) {
            LOG.error(e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static int showDialog(ConnectionOwner connectionOwner, String message, String title, String[] options) {
        Project project = connectionOwner.getProjectForDialogCreation();
        Component component = connectionOwner.getComponentForDialogCreation();
        if (project != null || component == null) {
            return Messages.showDialog((Project)project, (String)message, (String)title, (String[])options, (int)0, (Icon)Messages.getWarningIcon());
        }
        return Messages.showDialog((Component)component, (String)message, (String)title, (String[])options, (int)0, (Icon)Messages.getWarningIcon());
    }

    public static abstract class ListBased
    extends TransferTask {
        private List<? extends TransferOperation> myOperations;
        private boolean myErrorsDuringPrepare;
        private int myIndex;

        public ListBased(@NotNull Project project, boolean serverSideModification, PublishConfig publishConfig, WebServerConfig serverConfig, String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/TransferTask$ListBased", "<init>"));
            }
            if (revisionTracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionTracker", "com/jetbrains/plugins/webDeployment/TransferTask$ListBased", "<init>"));
            }
            this(project, ConnectionOwnerFactory.createConnectionOwner(project), serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker, DeploymentMode.CUSTOM);
        }

        public ListBased(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, WebServerConfig serverConfig, String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker) {
            if (connectionOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/TransferTask$ListBased", "<init>"));
            }
            if (revisionTracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionTracker", "com/jetbrains/plugins/webDeployment/TransferTask$ListBased", "<init>"));
            }
            this(project, connectionOwner, serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker, DeploymentMode.CUSTOM);
        }

        public ListBased(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, WebServerConfig serverConfig, String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker, @NotNull DeploymentMode mode) {
            if (connectionOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/TransferTask$ListBased", "<init>"));
            }
            if (revisionTracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionTracker", "com/jetbrains/plugins/webDeployment/TransferTask$ListBased", "<init>"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/plugins/webDeployment/TransferTask$ListBased", "<init>"));
            }
            super(project, connectionOwner, serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker, mode);
        }

        protected abstract ResultWithErrors buildOperationsList(ExecutionContext var1) throws FileSystemException;

        @Override
        protected boolean isMultipleOperations() {
            return this.myOperations.size() > 1;
        }

        @Override
        protected boolean prepareOperations(ExecutionContext context) throws FileSystemException {
            ResultWithErrors result = this.buildOperationsList(context);
            this.myOperations = result.operations;
            for (String message : result.errorMessages) {
                this.print(message, ConsoleViewContentType.ERROR_OUTPUT);
            }
            for (String excludedPath : result.excludedPaths) {
                this.print(WDBundle.message("excluded.message", excludedPath), ConsoleViewContentType.NORMAL_OUTPUT);
                context.incCounter("transfer.details.excluded");
            }
            this.myErrorsDuringPrepare = !result.errorMessages.isEmpty();
            return !this.myOperations.isEmpty();
        }

        @Override
        protected String getResultMessage(String title, Map<String, Integer> processed, int failed, long totalSize, long totalTime, long transferTime, boolean details) {
            String s = super.getResultMessage(title, processed, failed, totalSize, totalTime, transferTime, details);
            return this.myErrorsDuringPrepare && !details ? WDBundle.message("errors.during.prepare", new Object[0]) + "\n" + s : s;
        }

        @Override
        protected void printResultMessage(long time, long uploadTime) {
            if (this.myErrorsDuringPrepare) {
                this.print(WDBundle.message("errors.during.prepare", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            super.printResultMessage(time, uploadTime);
        }

        @Override
        protected MessageType getResultMessageType() {
            return this.myFailed == 0 && !this.myErrorsDuringPrepare ? MessageType.INFO : (this.myTotalProcessed > 0 ? MessageType.WARNING : MessageType.ERROR);
        }

        @Override
        @Nullable
        protected TransferOperation getNextOperation() {
            return this.myIndex < this.myOperations.size() ? this.myOperations.get(this.myIndex++) : null;
        }

        @Override
        protected int getDoneStepsNumber() {
            return this.myIndex - 1;
        }

        @Override
        protected int getTotalStepsNumber() {
            return this.myOperations.size();
        }

        @Override
        protected void assertAllExecuted(int totalProcessed, int failed) {
            LOG.assertTrue(this.myOperations.size() <= this.myTotalProcessed + this.myFailed, (Object)("total: " + this.myOperations.size() + ", processed: " + this.myProcessedCounters));
        }

        public static class ResultWithErrors {
            public final List<? extends TransferOperation> operations;
            public final Collection<String> errorMessages;
            public final Collection<String> excludedPaths;

            public ResultWithErrors(List<? extends TransferOperation> operations, DeploymentPathUtils.ErrorsAndExclusions errorsAndExclusions) {
                this.operations = operations;
                this.errorMessages = new ArrayList<String>();
                this.errorMessages.addAll(errorsAndExclusions.getReadOnlyErrors());
                this.excludedPaths = new ArrayList<String>();
                this.excludedPaths.addAll(errorsAndExclusions.getReadOnlyPaths());
            }
        }
    }
}

