/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.text.StringKt;
import com.jetbrains.plugins.webDeployment.config.OldStorageCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0015\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a.\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001c\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"createAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "server", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "isPasswordMemoryOnly", "", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "Lorg/jetbrains/annotations/Nullable;", "getRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "saveCredentials", "", "userName", "", "password", "syncWithPasswordSafe", "servers", "", "provider", "Lcom/jetbrains/plugins/webDeployment/config/OldStorageCredentialProvider;", "webDeployment"})
@JvmName(name="WebDeploymentCredentialHelper")
public final class WebDeploymentCredentialHelper {
    @JvmOverloads
    public static final void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password, boolean isPasswordMemoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        PasswordSafe.getInstance().set(WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly), new Credentials(StringKt.nullize((String)userName, (boolean)true), password));
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void saveCredentials$default(WebServerConfig webServerConfig, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveCredentials");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        WebDeploymentCredentialHelper.saveCredentials(webServerConfig, string, string2, bl);
    }

    @JvmOverloads
    public static void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password) {
        WebDeploymentCredentialHelper.saveCredentials$default(server, userName, password, false, 8, null);
    }

    public static final void syncWithPasswordSafe(@NotNull List<? extends WebServerConfig> servers, @NotNull OldStorageCredentialProvider provider) {
        Intrinsics.checkParameterIsNotNull(servers, (String)"servers");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        for (WebServerConfig webServerConfig : servers) {
            String password = StringKt.nullize$default((String)provider.getPassword(webServerConfig), (boolean)false, (int)1, null);
            String userName = StringKt.nullize$default((String)provider.getUser(webServerConfig), (boolean)false, (int)1, null);
            if (userName == null && password == null) continue;
            CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(webServerConfig, false);
            Credentials credentials = passwordSafe.get(attributes);
            if (credentials != null) {
                CharSequence charSequence = (CharSequence)credentials.getPassword();
                if (!(charSequence == null || charSequence.length() == 0) || password == null) continue;
            }
            passwordSafe.set(attributes, new Credentials(userName, password));
        }
    }

    @JvmOverloads
    @NotNull
    public static final CredentialAttributes createAttributes(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        return new CredentialAttributes("IntelliJ Platform Deployment \u2014 " + server.getId(), null, null, isPasswordMemoryOnly, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ CredentialAttributes createAttributes$default(WebServerConfig webServerConfig, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createAttributes");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return WebDeploymentCredentialHelper.createAttributes(webServerConfig, bl);
    }

    @JvmOverloads
    @NotNull
    public static CredentialAttributes createAttributes(@NotNull WebServerConfig server) {
        return WebDeploymentCredentialHelper.createAttributes$default(server, false, 2, null);
    }

    @Nullable
    public static final Credentials getCredentials(@NotNull WebServerConfig server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        return PasswordSafe.getInstance().get(WebDeploymentCredentialHelper.createAttributes(server, false));
    }

    @NotNull
    public static final RemoteCredentials getRemoteCredentials(@NotNull WebServerConfig server) {
        String password;
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Credentials credentials = WebDeploymentCredentialHelper.getCredentials(server);
        if (CredentialAttributesKt.isEmpty((Credentials)credentials)) {
            RemoteCredentials remoteCredentials = (RemoteCredentials)server.getFileTransferConfig().getCredentials();
            Intrinsics.checkExpressionValueIsNotNull((Object)remoteCredentials, (String)"server.fileTransferConfig.credentials");
            return remoteCredentials;
        }
        RemoteCredentialsVerifiableHolder remoteCredentials = server.getFileTransferConfig().getCredentials().clone();
        Credentials credentials2 = credentials;
        remoteCredentials.setUserName(credentials2 != null ? credentials2.getUserName() : null);
        Credentials credentials3 = credentials;
        String string = password = credentials3 != null ? credentials3.getPasswordAsString() : null;
        if (remoteCredentials.isUseKeyPair()) {
            remoteCredentials.setPassphrase(password);
        } else {
            remoteCredentials.setPassword(password);
        }
        RemoteCredentials remoteCredentials2 = (RemoteCredentials)remoteCredentials;
        Intrinsics.checkExpressionValueIsNotNull((Object)remoteCredentials2, (String)"remoteCredentials");
        return remoteCredentials2;
    }
}

