/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManagerBaseImpl;
import com.jetbrains.plugins.webDeployment.config.WebServersPasswordHelper;
import com.jetbrains.plugins.webDeployment.config.sftp.SftpAdvancedOptions;
import gnu.trove.THashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServersConfigManagerImpl
extends WebServersConfigManager {
    private static final Logger LOG = Logger.getInstance((String)WebServersConfigManager.class.getName());
    private final WebServersConfigManagerBaseImpl.App myAppManager;
    @Nullable
    private final WebServersConfigManagerBaseImpl.Project myProjectManager;

    public WebServersConfigManagerImpl(UltimateVerifier verifier, final Project project) {
        PluginVerifier.verifyUltimatePlugin(verifier);
        this.myAppManager = (WebServersConfigManagerBaseImpl.App)ServiceManager.getService(WebServersConfigManagerBaseImpl.App.class);
        if (project != null && !project.isDefault()) {
            this.myProjectManager = (WebServersConfigManagerBaseImpl.Project)ServiceManager.getService((Project)project, WebServersConfigManagerBaseImpl.Project.class);
            WebServersConfigManagerBaseImpl.Listener listener = new WebServersConfigManagerBaseImpl.Listener(){

                @Override
                public void serversLoaded() {
                    WebServersConfigManagerImpl.this.resolvePossibleServerCollisions(project);
                }
            };
            this.myProjectManager.addListener(listener, (Disposable)project);
            this.myAppManager.addListener(listener, (Disposable)project);
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.resolvePossibleServerCollisions(project));
        } else {
            this.myProjectManager = null;
        }
    }

    private void resolvePossibleServerCollisions(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerImpl", "resolvePossibleServerCollisions"));
        }
        LOG.assertTrue(this.myProjectManager != null);
        ArrayList<WebServerConfig> servers = new ArrayList<WebServerConfig>(this.getServers(false));
        HashSet globalServerNames = new HashSet();
        HashSet globalServerIds = new HashSet();
        HashSet projectServerNames = new HashSet();
        for (WebServerConfig server : servers) {
            if (!server.isProjectLevel()) {
                globalServerIds.add(server.getId());
                globalServerNames.add(server.getName());
                continue;
            }
            projectServerNames.add(server.getName());
        }
        HashSet previousProjectServerIds = new HashSet();
        HashMap oldToNew = new HashMap();
        for (WebServerConfig server : servers) {
            if (server.isProjectLevel() && (globalServerNames.contains(server.getName()) || globalServerIds.contains(server.getId()))) {
                WebServerConfig oldServer = server.clone();
                if (globalServerNames.contains(server.getName())) {
                    String serverNameBase = server.getName() + " (project level)";
                    int i = 1;
                    String serverName = serverNameBase;
                    while (globalServerNames.contains(serverName) || projectServerNames.contains(serverName)) {
                        serverName = serverNameBase + " (" + i + ")";
                        ++i;
                    }
                    server.setName(serverName);
                }
                while (globalServerIds.contains(server.getId()) || previousProjectServerIds.contains(server.getId())) {
                    server.setId(WebServerConfig.getNextId());
                }
                oldToNew.put(oldServer, server);
                projectServerNames.add(server.getName());
            }
            previousProjectServerIds.add(server.getId());
        }
        if (!oldToNew.isEmpty()) {
            this.setServers(servers);
            PublishConfig.getInstance(project).notifyServersPatched((Map<WebServerConfig, WebServerConfig>)oldToNew, servers);
        }
    }

    @Override
    public List<WebServerConfig> getServers(boolean remoteOnly) {
        if (remoteOnly) {
            ArrayList<WebServerConfig> result = new ArrayList<WebServerConfig>();
            if (this.myProjectManager != null) {
                WebServersConfigManagerImpl.addServers(remoteOnly, result, this.myProjectManager.myState.servers);
            }
            WebServersConfigManagerImpl.addServers(remoteOnly, result, ((WebServersConfigManagerBaseImpl.AppState)this.myAppManager.myState).servers);
            return result;
        }
        if (this.myProjectManager == null) {
            return Collections.unmodifiableList(((WebServersConfigManagerBaseImpl.AppState)this.myAppManager.myState).servers);
        }
        return new UnmodifiableWrapper(this.myProjectManager.myState.servers, ((WebServersConfigManagerBaseImpl.AppState)this.myAppManager.myState).servers);
    }

    private static void addServers(boolean remoteOnly, List<WebServerConfig> result, List<WebServerConfig> servers) {
        if (remoteOnly) {
            for (WebServerConfig server : servers) {
                if (!server.needsTransfer()) continue;
                result.add(server);
            }
        } else {
            result.addAll(servers);
        }
    }

    @Override
    public void setServers(@NotNull List<WebServerConfig> servers) {
        if (servers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servers", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerImpl", "setServers"));
        }
        THashMap oldServers = new THashMap();
        if (this.myProjectManager != null) {
            for (WebServerConfig server : this.myProjectManager.myState.servers) {
                oldServers.put(server.getId(), server);
            }
            this.myProjectManager.myState.servers.clear();
        }
        for (WebServerConfig server : ((WebServersConfigManagerBaseImpl.AppState)this.myAppManager.myState).servers) {
            oldServers.put(server.getId(), server);
        }
        ((WebServersConfigManagerBaseImpl.AppState)this.myAppManager.myState).servers.clear();
        for (WebServerConfig server : servers) {
            if (server.isProjectLevel()) {
                assert (this.myProjectManager != null);
                this.myProjectManager.myState.servers.add(server.clone());
                continue;
            }
            ((WebServersConfigManagerBaseImpl.AppState)this.myAppManager.myState).servers.add(server.clone());
        }
        WebServersPasswordHelper.updateData(servers, (Map<String, WebServerConfig>)oldServers);
    }

    @Override
    @NotNull
    public SftpAdvancedOptions getSftpAdvancedOptions() {
        SftpAdvancedOptions sftpAdvancedOptions = this.myAppManager.getSftpAdvancedOptions();
        if (sftpAdvancedOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerImpl", "getSftpAdvancedOptions"));
        }
        return sftpAdvancedOptions;
    }

    @Override
    public void setSftpAdvancedOptions(@NotNull SftpAdvancedOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerImpl", "setSftpAdvancedOptions"));
        }
        this.myAppManager.setSftpAdvancedOptions(options);
    }

    @Override
    public void addServer(WebServerConfig newServer) {
        assert (this.myProjectManager != null || !newServer.isProjectLevel());
        if (newServer.isProjectLevel()) {
            this.myProjectManager.myState.servers.add(newServer.clone());
        } else {
            ((WebServersConfigManagerBaseImpl.AppState)this.myAppManager.myState).servers.add(newServer.clone());
        }
        ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged();
    }

    @NotNull
    public static WebServersConfigManager getInstance(@Nullable Project project) {
        WebServersConfigManager webServersConfigManager = (WebServersConfigManager)ServiceManager.getService((Project)(project == null ? ProjectManager.getInstance().getDefaultProject() : project), WebServersConfigManager.class);
        if (webServersConfigManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerImpl", "getInstance"));
        }
        return webServersConfigManager;
    }

    @Override
    public WebServerConfig moveServer(WebServerConfig config) {
        LOG.assertTrue(this.myProjectManager != null);
        if (config.isProjectLevel()) {
            boolean remove = this.myProjectManager.myState.servers.remove(config);
            LOG.assertTrue(remove, (Object)("Can't find server '" + config.getName() + "'"));
            config.setIsProjectLevel(false);
            this.addServer(config);
        } else {
            boolean remove = ((WebServersConfigManagerBaseImpl.AppState)this.myAppManager.myState).servers.remove(config);
            LOG.assertTrue(remove, (Object)("Can't find server '" + config.getName() + "'"));
            config.setIsProjectLevel(true);
            this.addServer(config);
        }
        return config;
    }

    @NotNull
    public static List<WebServerConfig> getServersFromAllOpenProjects(boolean remoteOnly) {
        ArrayList<WebServerConfig> result = new ArrayList<WebServerConfig>();
        WebServersConfigManagerImpl.addServers(remoteOnly, result, ((WebServersConfigManagerBaseImpl.AppState)((WebServersConfigManagerBaseImpl.App)ServiceManager.getService(WebServersConfigManagerBaseImpl.App.class)).myState).servers);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            WebServersConfigManagerImpl.addServers(remoteOnly, result, ((WebServersConfigManagerBaseImpl.Project)ServiceManager.getService((Project)project, WebServersConfigManagerBaseImpl.Project.class)).myState.servers);
        }
        ArrayList<WebServerConfig> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerImpl", "getServersFromAllOpenProjects"));
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    static Map<String, WebServerConfig> collectUnpatchedServers(@Nullable Project project) {
        HashMap result = new HashMap();
        WebServersConfigManagerBaseImpl.App appService = (WebServersConfigManagerBaseImpl.App)ServiceManager.getService(WebServersConfigManagerBaseImpl.App.class);
        for (WebServerConfig server : ((WebServersConfigManagerBaseImpl.AppState)appService.myState).servers) {
            result.put(server.getId(), server);
        }
        if (project != null && !project.isDefault()) {
            WebServersConfigManagerBaseImpl.Project projectService = (WebServersConfigManagerBaseImpl.Project)ServiceManager.getService((Project)project, WebServersConfigManagerBaseImpl.Project.class);
            for (WebServerConfig server : projectService.myState.servers) {
                result.put(server.getId(), server);
            }
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerImpl", "collectUnpatchedServers"));
        }
        return hashMap;
    }

    private static class UnmodifiableWrapper
    extends AbstractList<WebServerConfig> {
        private final List<WebServerConfig> myFirstList;
        private final List<WebServerConfig> mySecondList;

        public UnmodifiableWrapper(List<WebServerConfig> firstList, List<WebServerConfig> secondList) {
            this.myFirstList = firstList;
            this.mySecondList = secondList;
        }

        @Override
        public WebServerConfig get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Negative index " + index);
            }
            if (index < this.myFirstList.size()) {
                return this.myFirstList.get(index);
            }
            if (index < this.myFirstList.size() + this.mySecondList.size()) {
                return this.mySecondList.get(index - this.myFirstList.size());
            }
            throw new IndexOutOfBoundsException("Too large index " + index + " for size " + this.size());
        }

        @Override
        public int size() {
            return this.myFirstList.size() + this.mySecondList.size();
        }
    }
}

