/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.auth;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.auth.LoginDialog;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthHelper {
    private static final Logger LOG = Logger.getInstance((String)AuthHelper.class.getName());
    private static final Map<Pair<WebServerConfig, Boolean>, Collection<AuthPair>> LOGIN_SERVERS = new THashMap();

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull WebServerConfig target, @NotNull Component component) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        return AuthHelper.ensureAuthSpecified(project, target, ConnectionOwnerFactory.createConnectionOwner(component));
    }

    public static boolean ensureAuthSpecified(@NotNull WebServerConfig target, @Nullable Project project) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, target, (Factory<LoginDialog>)((Factory)() -> {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "lambda$ensureAuthSpecified$0"));
            }
            return new LoginDialog(target, project, modal);
        }), modal);
    }

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull WebServerConfig target, @NotNull ConnectionOwner connectionOwner) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, target, (Factory<LoginDialog>)((Factory)() -> {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "lambda$ensureAuthSpecified$1"));
            }
            if (connectionOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "lambda$ensureAuthSpecified$1"));
            }
            return LoginDialog.createInstance(target, connectionOwner, modal);
        }), modal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ensureAuthSpecified(@Nullable Project project, WebServerConfig target, Factory<LoginDialog> dialog, boolean modal) {
        if (!target.getFileTransferConfig().getAccessType().isProtocolBased() || AuthHelper.hasCredentials(target)) {
            return true;
        }
        AuthPair resultPair = new AuthPair();
        Pair targetKey = Pair.create((Object)target, (Object)modal);
        Map<Pair<WebServerConfig, Boolean>, Collection<AuthPair>> map = LOGIN_SERVERS;
        synchronized (map) {
            Collection<AuthPair> refs = LOGIN_SERVERS.get(targetKey);
            if (refs != null) {
                LOG.assertTrue(!modal);
                refs.add(resultPair);
                try {
                    Collection<AuthPair> pairs;
                    while ((pairs = LOGIN_SERVERS.get(targetKey)) != null && pairs.contains(resultPair)) {
                        LOGIN_SERVERS.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return resultPair.username != null && resultPair.password != null;
            }
            LOGIN_SERVERS.put((Pair<WebServerConfig, Boolean>)targetKey, new ArrayList());
        }
        LOG.assertTrue(project != null || !target.isProjectLevel(), (Object)("Project '" + target.getName() + "' is project-level one. Please provide project."));
        Semaphore done = new Semaphore();
        Runnable runnable = () -> {
            LoginDialog d = (LoginDialog)((Object)((Object)dialog.create()));
            d.showAndGetResult().done(ok -> {
                if (ok.booleanValue()) {
                    resultPair.username = d.getUsername();
                    resultPair.password = d.getPassword();
                    resultPair.savePassword = d.isSavePassword();
                    if (!StringUtil.isEmpty((String)d.getUsername())) {
                        WebDeploymentCredentialHelper.saveCredentials(target, resultPair.username, resultPair.password, !resultPair.savePassword);
                    }
                    String serverId = target.getId();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (WebServersConfigManager.getInstance(project).findServer(serverId) != null) {
                            ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged();
                        }
                    });
                }
                Map<Pair<WebServerConfig, Boolean>, Collection<AuthPair>> map = LOGIN_SERVERS;
                synchronized (map) {
                    for (AuthPair pair : LOGIN_SERVERS.remove(targetKey)) {
                        pair.username = resultPair.username;
                        pair.password = resultPair.password;
                        pair.savePassword = resultPair.savePassword;
                    }
                    LOGIN_SERVERS.notifyAll();
                }
                if (!modal) {
                    done.up();
                }
            });
        };
        if (!modal) {
            done.down();
            ApplicationManager.getApplication().invokeAndWait(runnable);
            done.waitFor();
        } else {
            runnable.run();
        }
        return resultPair.username != null && resultPair.password != null;
    }

    public static boolean hasCredentials(@NotNull WebServerConfig server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "hasCredentials"));
        }
        FileTransferConfig fileTransferConfig = server.getFileTransferConfig();
        if (fileTransferConfig.isAnonymous()) {
            return true;
        }
        Credentials credentials = WebDeploymentCredentialHelper.getCredentials(server);
        if (CredentialAttributesKt.isFulfilled((Credentials)credentials)) {
            return true;
        }
        if (fileTransferConfig.isUseKeyPair()) {
            try {
                if (!KeyPair.load((JSch)new JSch(), (String)fileTransferConfig.getPrivateKeyFile()).isEncrypted()) {
                    return true;
                }
            }
            catch (JSchException e) {
                LOG.error((Throwable)e);
                return false;
            }
        }
        return false;
    }

    private static class AuthPair {
        public String username;
        public String password;
        public boolean savePassword;

        private AuthPair() {
        }
    }
}

