/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.auth;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.LoginForm;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

class LoginDialog
extends DialogWrapper {
    private LoginForm myForm;
    private AsyncPromise<Boolean> myResult = new AsyncPromise();

    public static LoginDialog createInstance(WebServerConfig target, @NotNull ConnectionOwner connectionOwner, boolean modal) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/LoginDialog", "createInstance"));
        }
        Component parentComponent = connectionOwner.getComponentForDialogCreation();
        if (parentComponent != null) {
            return new LoginDialog(target, parentComponent, modal);
        }
        return new LoginDialog(target, connectionOwner.getProjectForDialogCreation(), modal);
    }

    public LoginDialog(WebServerConfig target, @Nullable Project project, boolean modal) {
        super(project, false);
        this.initialize(target, modal);
    }

    public LoginDialog(WebServerConfig target, Component parent, boolean modal) {
        super(parent, false);
        this.initialize(target, modal);
    }

    private void initialize(WebServerConfig target, boolean modal) {
        this.setModal(modal);
        String name = target.getName();
        if (StringUtil.isEmpty((String)name)) {
            name = target.getFileTransferConfig().getHost();
        }
        this.setTitle(WDBundle.message("login.dialog.title", name, target.getFileTransferConfig().getAccessType().getTitle()));
        this.myForm = new LoginForm(target);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    public String getUsername() {
        return this.myForm.getUsername();
    }

    public String getPassword() {
        return this.myForm.getPassword();
    }

    public boolean isSavePassword() {
        return this.myForm.isSavePassword();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myResult.setResult((Object)true);
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.myResult.setResult((Object)false);
    }

    protected String getDimensionServiceKey() {
        return "publish.login";
    }

    public Promise<Boolean> showAndGetResult() {
        this.show();
        return this.myResult;
    }
}

