/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.ui.TabbedPaneWrapper;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.WebServerConfigForm;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentConfigurableForm
implements UnnamedConfigurable,
Iconable,
Disposable,
DeploymentConfigurableTabProvider.ServerStateProvider {
    private TabbedPaneWrapper myTabbedPaneWrapper;
    private final List<DeploymentConfigurableTab> myTabs = new ArrayList<DeploymentConfigurableTab>();
    private final WebServerConfig myServer;
    @Nullable
    private final Project myProject;
    private boolean myComponentInitialized;

    public DeploymentConfigurableForm(WebServerConfig server, @Nullable Project project) {
        this.myServer = server;
        this.myProject = project;
        this.myTabbedPaneWrapper = new TabbedPaneWrapper((Disposable)this);
    }

    public void addTab(DeploymentConfigurableTab tab) {
        this.myTabs.add(tab);
        Disposer.register((Disposable)this, (Disposable)tab);
        this.myTabbedPaneWrapper.addTab(tab.getTitle(), (JComponent)new TabWrapper(tab.createComponent()));
    }

    public Icon getIcon(int flags) {
        WebServerConfigForm serverForm = this.getServerForm();
        return serverForm == null ? this.myServer.getFileTransferConfig().getIcon() : serverForm.getIcon(flags);
    }

    public JComponent createComponent() {
        if (!this.myComponentInitialized) {
            this.myComponentInitialized = true;
            this.addTab(new ServerTab(this.myServer, this.myProject));
            this.setUpComponent();
        }
        return this.myTabbedPaneWrapper.getComponent();
    }

    protected abstract void setUpComponent();

    public WebServerConfig compute() {
        return this.getServerForm().getCurrentState();
    }

    @Override
    public void updatePassword(WebServerConfig server) {
        this.getServerForm().updatePassword(server);
    }

    @Override
    public String getServerId() {
        return this.myServer.getId();
    }

    @Override
    public String getServerName() {
        return this.myServer.getName();
    }

    @Override
    public void addListener(final ChangeListener l, Disposable parentDisposable) {
        this.getServerForm().addListener(new WebServerConfigForm.Listener(){

            @Override
            public void changed(WebServerConfig effective) {
                l.stateChanged(new ChangeEvent(effective));
            }
        }, parentDisposable);
    }

    public void fireChanged() {
        this.getServerForm().fireChanged();
    }

    public boolean isModified() {
        for (DeploymentConfigurableTab tab : this.myTabs) {
            if (!tab.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.myServer);
    }

    public void applyTo(WebServerConfig server) throws ConfigurationException {
        for (DeploymentConfigurableTab tab : this.myTabs) {
            tab.applyTo(server);
        }
    }

    public void reset() {
        for (DeploymentConfigurableTab tab : this.myTabs) {
            tab.reset();
        }
    }

    public void dispose() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
        for (DeploymentConfigurableTab tab : this.myTabs) {
            tab.disposeUIResources();
        }
    }

    public void addItemPresentationChangeListener(DeploymentConfigurableTab.ItemPresentationChangeListener listener, Disposable parentDisposable) {
        for (DeploymentConfigurableTab tab : this.myTabs) {
            tab.addItemPresentationChangeListener(listener, parentDisposable);
        }
    }

    @Nullable
    private WebServerConfigForm getServerForm() {
        if (this.myTabs.isEmpty()) {
            return null;
        }
        return ((ServerTab)this.myTabs.get(0)).getForm();
    }

    public void addTabChangeListener(ChangeListener l) {
        this.myTabbedPaneWrapper.addChangeListener(l);
    }

    public int getSelectedTabIndex() {
        return this.myTabbedPaneWrapper.getSelectedIndex();
    }

    public void setSelectedTabIndex(int tabIndex) {
        this.createComponent();
        this.myTabbedPaneWrapper.setSelectedIndex(tabIndex);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent(int tabIndex) {
        return this.myTabs.get(tabIndex).getPreferredFocusedComponent();
    }

    private static class ServerTab
    implements DeploymentConfigurableTab {
        @Nullable
        private final Project myProject;
        private final WebServerConfig myServer;
        @Nullable
        private WebServerConfigForm myForm;

        public ServerTab(WebServerConfig server, @Nullable Project project) {
            this.myServer = server;
            this.myProject = project;
        }

        @Override
        public String getTitle() {
            return WDBundle.message("deployment.configurable.tab.connection", new Object[0]);
        }

        @Override
        public int getWeight() {
            return 0;
        }

        public JComponent createComponent() {
            return this.getForm().createComponent();
        }

        public boolean isModified() {
            return this.getForm().isModified();
        }

        public void apply() throws ConfigurationException {
            this.getForm().apply();
        }

        @Override
        public void applyTo(WebServerConfig server) {
            this.getForm().applyTo(server, true);
        }

        public void reset() {
            this.getForm().reset();
        }

        public void disposeUIResources() {
            this.getForm().disposeUIResources();
        }

        public void dispose() {
        }

        @NotNull
        public WebServerConfigForm getForm() {
            if (this.myForm == null) {
                this.myForm = new WebServerConfigForm(this.myServer, this.myProject);
            }
            WebServerConfigForm webServerConfigForm = this.myForm;
            if (webServerConfigForm == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurableForm$ServerTab", "getForm"));
            }
            return webServerConfigForm;
        }

        @Override
        public void addItemPresentationChangeListener(DeploymentConfigurableTab.ItemPresentationChangeListener listener, Disposable parentDisposable) {
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.getForm().getPreferredFocusedComponent();
        }
    }

    private static class TabWrapper
    extends JPanel {
        public TabWrapper(@NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurableForm$TabWrapper", "<init>"));
            }
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)component, "Center");
        }
    }
}

