/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ArrayListSet;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.RemoteMoveProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class MoveCopyPasteSupport
implements CopyPasteSupport {
    public CutProvider getCutProvider() {
        return new MyCutProvider();
    }

    public CopyProvider getCopyProvider() {
        return new MyCopyProvider();
    }

    public PasteProvider getPasteProvider() {
        return new MyPasteProvider();
    }

    public static class RemoteHostCopyPasteListener
    implements CopyPasteManager.ContentChangedListener {
        private final AbstractTreeUpdater myUpdater;
        private final JTree myTree;

        public RemoteHostCopyPasteListener(AbstractTreeUpdater updater, JTree tree) {
            this.myUpdater = updater;
            this.myTree = tree;
        }

        public void contentChanged(Transferable oldTransferable, Transferable newTransferable) {
            this.updateByTransferable(oldTransferable);
            this.updateByTransferable(newTransferable);
        }

        private void updateByTransferable(Transferable t) {
            PsiElement[] elements = CopyPasteUtil.getElementsInTransferable((Transferable)t);
            if (elements.length == 0) {
                return;
            }
            PsiElement fileWithData = elements[0];
            Collection<WebServerConfig.RemotePath> paths = RemoteMoveProvider.getPaths(fileWithData);
            if (paths == null || paths.isEmpty()) {
                return;
            }
            Collection<ServerTreeNode> nodes = RemoteMoveProvider.getServerNodes(paths, this.myTree);
            if (nodes == null) {
                return;
            }
            for (ServerTreeNode serverTreeNode : nodes) {
                this.myUpdater.addSubtreeToUpdateByElement((Object)serverTreeNode.getParent());
            }
        }
    }

    private static class MyPasteProvider
    implements PasteProvider {
        private MyPasteProvider() {
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyPasteProvider", "performPaste"));
            }
            ServerTreeNode[] serverNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
            if (serverNodes == null || serverNodes.length == 0) {
                return;
            }
            ServerTreeNode targetNode = serverNodes[0];
            ServerTree tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(dataContext));
            if (tree == null) {
                return;
            }
            if (RemoteMoveProvider.isFromRemotePasteEnabled(dataContext, true)) {
                PsiElement element = RemoteMoveProvider.getCutPsiElementWithData();
                if (element == null) {
                    return;
                }
                RemoteMoveProvider.performRemoteToRemotePaste(element, targetNode);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(""));
            } else if (MyPasteProvider.isFromProjectViewPasteEnabled(dataContext)) {
                boolean[] isCopied = new boolean[1];
                PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(isCopied);
                if (elements == null || elements.length == 0) {
                    return;
                }
                ArrayListSet sourceElements = new ArrayListSet();
                for (PsiElement element : elements) {
                    if (!(element instanceof PsiFileSystemItem)) {
                        return;
                    }
                    VirtualFile file = ((PsiFileSystemItem)element).getVirtualFile();
                    if (file == null || !file.isValid()) {
                        return;
                    }
                    sourceElements.add(file);
                }
                RemoteMoveProvider.performLocalToRemotePaste((Collection<VirtualFile>)sourceElements, targetNode, tree, tree.getProject(), tree.getServer(), !isCopied[0]);
            }
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyPasteProvider", "isPastePossible"));
            }
            return this.isPasteEnabled(dataContext);
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyPasteProvider", "isPasteEnabled"));
            }
            return RemoteMoveProvider.isFromRemotePasteEnabled(dataContext, true) || MyPasteProvider.isFromProjectViewPasteEnabled(dataContext);
        }

        private static boolean isFromProjectViewPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyPasteProvider", "isFromProjectViewPasteEnabled"));
            }
            WebServerConfig config = (WebServerConfig)WebDeploymentDataKeys.SERVER_CONFIG.getData(dataContext);
            if (config == null) {
                return false;
            }
            ServerTreeNode[] treeNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
            if (treeNodes == null || treeNodes.length != 1) {
                return false;
            }
            boolean[] isCopied = new boolean[1];
            PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(isCopied);
            if (elements == null || elements.length == 0) {
                return false;
            }
            if (treeNodes[0].getProject() != elements[0].getProject()) {
                return false;
            }
            for (PsiElement element : elements) {
                if (!(element instanceof PsiFileSystemItem)) {
                    return false;
                }
                VirtualFile file = ((PsiFileSystemItem)element).getVirtualFile();
                if (file != null && file.isValid() && file.isInLocalFileSystem()) continue;
                return false;
            }
            return true;
        }
    }

    private static class MyCopyProvider
    implements CopyProvider {
        private MyCopyProvider() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCopyProvider", "performCopy"));
            }
            ServerTree tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(dataContext));
            if (tree == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(new PsiElement[]{RemoteMoveProvider.createPsiElementWithData(tree)}, true);
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCopyProvider", "isCopyEnabled"));
            }
            return RemoteMoveProvider.checkNotEmpty((ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext), true);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCopyProvider", "isCopyVisible"));
            }
            return true;
        }
    }

    private static class MyCutProvider
    implements CutProvider {
        private MyCutProvider() {
        }

        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCutProvider", "performCut"));
            }
            ServerTree tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(dataContext));
            if (tree == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(new PsiElement[]{RemoteMoveProvider.createPsiElementWithData(tree)}, false);
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCutProvider", "isCutEnabled"));
            }
            return RemoteMoveProvider.checkNotEmpty((ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext), false);
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCutProvider", "isCutVisible"));
            }
            return true;
        }
    }
}

