/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StreamProviderWrapper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a,\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"copyLocalConfig", "", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getRoamingType", "Lcom/intellij/openapi/components/RoamingType;", "components", "", "Lcom/intellij/configurationStore/ExportableItem;", "saveDirectory", "parent", "Ljava/nio/file/Path;", "parentFileSpec", "", "roamingType", "streamProvider", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lorg/jetbrains/settingsRepository/IcsManager;", "settings-repository"})
public final class CopyAppSettingsToRepositoryKt {
    public static final void copyLocalConfig(@NotNull StateStorageManagerImpl storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        StreamProvider streamProvider = StreamProviderWrapper.getOriginalProvider((StreamProvider)storageManager.getStreamProvider());
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        if (streamProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        Map fileToComponents = ExportSettingsActionKt.getExportableComponentsMap$default((boolean)true, (boolean)false, (StateStorageManager)((StateStorageManager)storageManager), null, (int)8, null);
        Collection $receiver$iv = fileToComponents.keySet();
        List errors$iv = null;
        for (Object element$iv : $receiver$iv) {
            try {
                String fileSpec;
                Path file;
                block10: {
                    file = (Path)element$iv;
                    try {
                        String canonicalPath;
                        String absolutePath = PathKt.getSystemIndependentPath((Path)file.toAbsolutePath());
                        fileSpec = StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacros(absolutePath), (String)SchemeManagerFactoryImplKt.ROOT_CONFIG);
                        if (!Intrinsics.areEqual((Object)fileSpec, (Object)absolutePath) || !(Intrinsics.areEqual((Object)(canonicalPath = PathKt.getSystemIndependentPath((Path)file.toRealPath(new LinkOption[0]))), (Object)absolutePath) ^ true)) break block10;
                        fileSpec = StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacros(canonicalPath), (String)SchemeManagerFactoryImplKt.ROOT_CONFIG);
                    }
                    catch (NoSuchFileException e) {
                        continue;
                    }
                }
                Object v = fileToComponents.get(file);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                RoamingType roamingType = CopyAppSettingsToRepositoryKt.getRoamingType((Collection)v);
                if (PathKt.isFile((Path)file)) {
                    byte[] fileBytes = PathKt.readBytes((Path)file);
                    streamProvider2.doSave(fileSpec, fileBytes, fileBytes.length, roamingType);
                    continue;
                }
                CopyAppSettingsToRepositoryKt.saveDirectory(file, fileSpec, roamingType, streamProvider2);
            }
            catch (Throwable e$iv) {
                if (errors$iv == null) {
                    errors$iv = (List)new SmartList();
                }
                errors$iv.add(e$iv);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)errors$iv);
    }

    public static /* bridge */ /* synthetic */ void copyLocalConfig$default(StateStorageManagerImpl stateStorageManagerImpl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyLocalConfig");
        }
        if ((n & 1) != 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
            if (stateStorageManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
            }
            stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        }
        CopyAppSettingsToRepositoryKt.copyLocalConfig(stateStorageManagerImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void saveDirectory(Path parent, String parentFileSpec, RoamingType roamingType, IcsManager.IcsStreamProvider streamProvider) {
        Path path = parent;
        try {
            void $receiver$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv);
            boolean bl = false;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                for (Path file : it) {
                    String childFileSpec = parentFileSpec + "/" + file.getFileName();
                    if (PathKt.isFile((Path)file)) {
                        byte[] fileBytes = Files.readAllBytes(file);
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                        streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                        continue;
                    }
                    Path path2 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                    CopyAppSettingsToRepositoryKt.saveDirectory(path2, childFileSpec, roamingType, streamProvider);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        catch (NoSuchFileException ignored$iv) {
        }
    }

    private static final RoamingType getRoamingType(Collection<ExportableItem> components) {
        for (ExportableItem component : components) {
            if (!(component instanceof ExportableItem)) continue;
            return component.getRoamingType();
        }
        return RoamingType.DEFAULT;
    }
}

