/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.auth.AuthenticationException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;

abstract class AbstractHttpClient {
    static final String JSON_CONTENT_TYPE = "application/json";
    static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";
    static final String ACCEPT_HEADER_NAME = "Accept";
    static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    static final String ACCEPT_ENC_HEADER_NAME = "Accept-Encoding";
    static final String CONTENT_ENC_HEADER_NAME = "Content-Encoding";
    static final String DEFLATE_METHOD_NAME = "deflate";
    static final String GZIP_METHOD_NAME = "gzip";
    static final String HTTP_GET = "GET";
    static final String HTTP_PUT = "PUT";
    static final String HTTP_DELETE = "DELETE";
    static final String HTTP_OPTIONS = "OPTIONS";
    public static final String ENCODING = "UTF-8";
    protected static final Gson GSON = new GsonBuilder().serializeNulls().create();
    protected final String endpoint;
    protected final Configuration config;

    protected AbstractHttpClient(String endpoint) {
        this(endpoint, new Configuration());
    }

    protected AbstractHttpClient(String endpoint, Configuration config) {
        if (!endpoint.matches("^https?://.*$")) {
            throw new IllegalArgumentException("Invalid protocol: " + endpoint);
        }
        if (config == null) {
            throw new IllegalArgumentException("Client configuration must be passed");
        }
        this.endpoint = endpoint.replaceFirst("/+$", "");
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T download(String method, URL url, Map<String, String> props, StreamParser<T> parser, boolean closeStream) throws IOException {
        InputStream in;
        HttpURLConnection connection = this.config.openConnection(url);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setRequestProperty(ACCEPT_ENC_HEADER_NAME, "gzip, deflate");
        connection.setRequestMethod(method);
        try {
            in = connection.getInputStream();
        }
        catch (IOException e) {
            if (connection.getResponseCode() == 401) {
                throw new AuthenticationException("Authentication failure", e);
            }
            throw e;
        }
        try {
            String responseEncoding = connection.getHeaderField(CONTENT_ENC_HEADER_NAME);
            if (GZIP_METHOD_NAME.equalsIgnoreCase(responseEncoding)) {
                in = new GZIPInputStream(in);
            } else if (DEFLATE_METHOD_NAME.equalsIgnoreCase(responseEncoding)) {
                in = new DeflaterInputStream(in);
            }
            T t = parser.parse(in);
            return t;
        }
        finally {
            if (closeStream) {
                this.closeSafely(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload(String method, URL url, Map<String, String> props, StreamWriter writer) throws IOException {
        HttpURLConnection connection = this.config.openConnection(url);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        OutputStream out = connection.getOutputStream();
        try {
            writer.write(out);
            this.assertSuccess(connection);
        }
        finally {
            this.closeSafely(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSuccess(HttpURLConnection connection) throws IOException {
        if (connection.getResponseCode() == 401) {
            throw new AuthenticationException("Failed to authenticate with given credentials");
        }
        if (connection.getResponseCode() != 204) {
            String message = "";
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                try {
                    IOException ioException;
                    Scanner scanner = new Scanner(errorStream).useDelimiter("\\A");
                    if (scanner.hasNext()) {
                        message = scanner.next();
                    }
                    if ((ioException = scanner.ioException()) != null) {
                        System.err.println("Failed to read error message");
                        ioException.printStackTrace();
                    }
                }
                finally {
                    this.closeSafely(errorStream);
                }
            }
            throw new RuntimeException(String.format("Unexpected response (code: %s, message: %s)", connection.getResponseCode(), message));
        }
    }

    protected void closeSafely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close resource");
            e.printStackTrace();
        }
    }

    protected static interface StreamWriter {
        public void write(OutputStream var1) throws IOException;
    }

    protected static interface StreamParser<T> {
        public T parse(InputStream var1) throws IOException;
    }
}

