/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class Utilities {
    private Utilities() {
    }

    static String[] split(String s, String regex) {
        return Utilities.split(s, Pattern.compile(regex));
    }

    static String[] split(String s, Pattern pattern) {
        return s.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : pattern.split(s);
    }

    static String join(Collection<String> strings) {
        return Utilities.join(strings, ", ");
    }

    static String join(Collection<String> strings, String delimiter) {
        return strings.stream().collect(Collectors.joining(delimiter));
    }

    static <T> void ensureSize(ArrayList<T> list, int size, Supplier<T> defaultValue) {
        list.ensureCapacity(size);
        while (list.size() < size) {
            list.add(defaultValue.get());
        }
    }

    static <T> Set<T> flatten(Collection<Set<T>> elements) {
        return elements.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    static <T> boolean exists(Collection<T> elements, Predicate<T> predicate) {
        return elements.stream().filter(predicate).findAny().isPresent();
    }

    static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.retainAll(set2);
        return result;
    }
}

