/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Objects {
    @Contract(value="_,!null->!null; _,null->null")
    public static <C> C castTo(@NotNull Class<C> clazz, @Nullable Object object) throws ClassCastException {
        if (object != null) {
            Class<?> objectClass = object.getClass();
            if (clazz.isAssignableFrom(objectClass)) {
                return (C)object;
            }
            String kind = clazz.isInterface() ? "interface" : "class";
            String msg = String.format("cannot cast object of class %s to %s %s.", objectClass.getName(), kind, clazz.getName());
            throw new ClassCastException(msg);
        }
        return null;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        return value != null ? value : defaultValue;
    }
}

