/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import android.content.IClipboard;
import android.content.IOnPrimaryClipChangedListener;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.util.ArrayList;

public class ClipboardManager
extends android.text.ClipboardManager {
    private static final Object sStaticLock = new Object();
    private static IClipboard sService;
    private final Context mContext;
    private final ArrayList<OnPrimaryClipChangedListener> mPrimaryClipChangedListeners = new ArrayList();
    private final IOnPrimaryClipChangedListener.Stub mPrimaryClipChangedServiceListener = new IOnPrimaryClipChangedListener.Stub(){

        @Override
        public void dispatchPrimaryClipChanged() {
            ClipboardManager.this.mHandler.sendEmptyMessage(1);
        }
    };
    static final int MSG_REPORT_PRIMARY_CLIP_CHANGED = 1;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ClipboardManager.this.reportPrimaryClipChanged();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IClipboard getService() {
        Object object = sStaticLock;
        synchronized (object) {
            if (sService != null) {
                return sService;
            }
            IBinder b = ServiceManager.getService("clipboard");
            sService = IClipboard.Stub.asInterface(b);
            return sService;
        }
    }

    public ClipboardManager(Context context, Handler handler) {
        this.mContext = context;
    }

    public void setPrimaryClip(ClipData clip) {
        try {
            if (clip != null) {
                clip.prepareToLeaveProcess(true);
            }
            ClipboardManager.getService().setPrimaryClip(clip, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ClipData getPrimaryClip() {
        try {
            return ClipboardManager.getService().getPrimaryClip(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ClipDescription getPrimaryClipDescription() {
        try {
            return ClipboardManager.getService().getPrimaryClipDescription(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasPrimaryClip() {
        try {
            return ClipboardManager.getService().hasPrimaryClip(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimaryClipChangedListener(OnPrimaryClipChangedListener what) {
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            if (this.mPrimaryClipChangedListeners.size() == 0) {
                try {
                    ClipboardManager.getService().addPrimaryClipChangedListener(this.mPrimaryClipChangedServiceListener, this.mContext.getOpPackageName());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mPrimaryClipChangedListeners.add(what);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimaryClipChangedListener(OnPrimaryClipChangedListener what) {
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            this.mPrimaryClipChangedListeners.remove(what);
            if (this.mPrimaryClipChangedListeners.size() == 0) {
                try {
                    ClipboardManager.getService().removePrimaryClipChangedListener(this.mPrimaryClipChangedServiceListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @Override
    public CharSequence getText() {
        ClipData clip = this.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).coerceToText(this.mContext);
        }
        return null;
    }

    @Override
    public void setText(CharSequence text) {
        this.setPrimaryClip(ClipData.newPlainText(null, text));
    }

    @Override
    public boolean hasText() {
        try {
            return ClipboardManager.getService().hasClipboardText(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportPrimaryClipChanged() {
        Object[] listeners;
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            int N = this.mPrimaryClipChangedListeners.size();
            if (N <= 0) {
                return;
            }
            listeners = this.mPrimaryClipChangedListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((OnPrimaryClipChangedListener)listeners[i]).onPrimaryClipChanged();
        }
    }

    public static interface OnPrimaryClipChangedListener {
        public void onPrimaryClipChanged();
    }
}

