-- noinspection SqlResolveForFile


---- QueryCurrentSessionInfo ----
select db_id()                                                 as db_id,
       db_name()                                               as db_name,
       schema_id()                                             as schema_id,
       schema_name()                                           as schema_name,
       cast(databasepropertyex(db_name(),'collation') as char) as collation_name
;


---- Now ----
select getdate()
;


---- ListDatabases ----
select dbid as id, name
from master.dbo.sysdatabases
order by case when dbid = db_id() then 1 else 0 end desc, dbid
;


---- ListSchemas ----
select uid as id, name
from #CAT.sysusers
order by case when uid = user_id() then 1 else 0 end desc, uid
;


---- RetrieveSchemas ----
select uid as id, name
from #CAT.sysusers
;


---- RetrieveMajorNames ----
select id,
       cast (substring(type,char_length(rtrim(type)),1) as char(1)) as type,
       name,
       schemacnt as state_nr
from #CAT.sysobjects
where uid = ?
  and type in ('U', 'S', 'V', 'SF', 'P', 'XP')
order by id
;


---- RetrieveProcedures ----
select distinct P.id,
                P.number as procedure_position
from #CAT.sysobjects O,
     #CAT.sysprocedures P
where O.uid = ?
  and O.type = 'P'
  and O.id = P.id
order by 1, 2
;


---- RetrieveColumnsAndArguments ----
select C.id,
       C.number as procedure_position,
       C.colid,
       C.name,
       Y.name as type_name,
       Y.variable,
       C.length,
       C.prec,
       C.scale,
       C.status as bits1,
       C.status2 & 32767 as bits2
from #CAT.sysobjects O
     left join #CAT.syscolumns C on O.id = C.id
     left outer join #CAT.systypes Y on C.usertype = Y.usertype
where O.uid = ?
  and C.name != null
order by 1,2,3
;


---- RetrieveDefaults ----
select T.id, C.colid as position, D.text
from #CAT.sysobjects T,
     #CAT.syscolumns C,
     #CAT.syscomments D
where T.uid = ?
  and T.id = C.id
  and (C.cdefault = D.id or C.computedcol = D.id)
order by T.id, C.colid
;


---- RetrieveIndices ----
select I.id,
       I.indid as position,
       I.name,
       I.status  as bits1,
       I.status2 as bits2,
       I.keys1,
       I.keys2
from #CAT.sysobjects T,
     #CAT.sysindexes I
where uid = ?
  and T.id = I.id
  and I.indid not in (0,255)
order by I.id, I.indid
;


---- RetrieveForeignKeys ----
select R.constrid as source_constraint_id,
       R.tableid as source_table_id,
       R.reftabid as target_table_id,
       R.indexid as target_index_position,
       R.keycnt as involved_columns_count,
       F.name as source_constraint_name,
       R.fokey1 as column_position_1,
       R.fokey2 as column_position_2,
       R.fokey3 as column_position_3,
       R.fokey4 as column_position_4
from #CAT.sysobjects F,
     #CAT.sysreferences R
where F.uid = ?
  and F.type = 'RI'
  and F.id = R.constrid
order by R.tableid, R.constrid
;


---- RetrieveForeignKeysWideColumnLists ----
select R.constrid,
       R.fokey1,
       R.fokey2,
       R.fokey3,
       R.fokey4,
       R.fokey5,
       R.fokey6,
       R.fokey7,
       R.fokey8,
       R.fokey9,
       R.fokey10,
       R.fokey11,
       R.fokey12,
       R.fokey13,
       R.fokey14,
       R.fokey15,
       R.fokey16
from #CAT.sysobjects F,
     #CAT.sysreferences R
where F.uid = ?
  and F.type = 'RI'
  and F.id = R.constrid
  and R.keycnt > 4
;


---- RetrieveChecks ----
select H.tableid as table_id,
       H.constrid as constraint_id,
       C.name as constraint_name,
       S.text as definition,
       H.colid as column_position
from #CAT.sysobjects T,
     #CAT.sysobjects C,
     #CAT.sysconstraints H
         left outer join #CAT.syscomments S on H.constrid = S.id
where T.uid = ?
  and C.uid = T.uid
  and H.tableid = T.id
  and H.constrid = C.id
  and H.status & 128 > 0
order by H.tableid, H.constrid
;


---- RetrieveTriggers ----
select T.id as table_id,
       'I' as event_code,
       substring(G.type,1,1) as turn_code,
       G.id as trig_id,
       G.name as trig_name
from #CAT.sysobjects T
     join #CAT.sysobjects G on T.instrig = G.id
where T.uid = ?
  and T.type in ('S','U','V')
union
select T.id as table_id,
       'U' as event_code,
       substring(G.type,1,1) as turn_code,
       G.id as trig_id,
       G.name as trig_name
from #CAT.sysobjects T
     join #CAT.sysobjects G on T.updtrig = G.id
where T.uid = ?
  and T.type in ('S','U','V')
union
select T.id as table_id,
       'D' as event_code,
       substring(G.type,1,1) as turn_code,
       G.id as trig_id,
       G.name as trig_name
from #CAT.sysobjects T
     join #CAT.sysobjects G on T.deltrig = G.id
where T.uid = ?
  and T.type in ('S','U','V')
order by 1,3
;


---- RetrieveSources ----
select case when MO.type='SF' then 'F' else MO.type end as major_kind,
       MO.id as major_id,
       case when MO.type='P' then 'P' else null end as minor_kind,
       case when MO.type='P' then MC.number else null end as minor_id,
       MC.text
from #CAT.sysobjects MO,
     #CAT.syscomments MC
where MO.uid = ?
  and MO.type in ('V','SF','P')
  and MO.id = MC.id
union all
select case when TT.type='U' then 'T' else TT.type end as major_kind,
       TT.id as major_id,
       'G' as minor_kind,
       TG.id as minor_id,
       TC.text
from #CAT.sysobjects TT,
     #CAT.sysobjects TG,
     #CAT.syscomments TC
where TT.uid = ?
  and TT.id = TG.deltrig
  and TG.uid = ?
  and TG.id = TC.id
;