import {extendEx} from "./util";
import {HolderContainer} from "./compile-info-holder";
import {serverLogger} from "./logger-impl";


export function extendProjectServiceNew(TypeScriptProjectService: typeof ts.server.ProjectService,
                                        ts_impl: typeof ts,
                                        host: ts.server.ServerHost,
                                        projectEmittedWithAllFiles: HolderContainer) {
    if (!overrideParseJsonConfigFileContent(ts_impl)) {
        return;
    }

    extendEx(TypeScriptProjectService, "convertConfigFileContentToProjectOptions", function (this: ts.server.ProjectService,
                                                                                             oldFunction: (configFilename: string) => void,
                                                                                             args: any[]) {
        if (!oldFunction) {
            serverLogger("ERROR: method convertConfigFileContentToProjectOptions doesn't exist", true);
            return;
        }

        let options = oldFunction.apply(this, args);
        if (options) {
            if (options.projectOptions) {
                serverLogger("Updated compileOnSave");
                //By default ts service consider compileOnSave === undefined -> compileOnSave == false
                //we need override this behaviour
                if (options.projectOptions.compileOnSave == null) {
                    options.projectOptions.compileOnSave = true;

                }

                if (options.projectOptions.compilerOptions) {
                    options.projectOptions.compilerOptions.___processed_marker = true;
                }
            }
        }

        return options;
    })


}


function overrideParseJsonConfigFileContent(ts_impl: typeof ts): boolean {
    let parseJsonConfigFileContentOld = (<any>ts_impl).parseJsonConfigFileContent;

    if (!parseJsonConfigFileContentOld) {
        return false;
    }

    (<any>ts_impl).parseJsonConfigFileContent = function (this: any) {

        let jsonOption = arguments[0];
        if (!ts_impl.hasProperty(jsonOption, (<any>ts_impl).compileOnSaveCommandLineOption.name)) {
            serverLogger("No compileOnSave — return true");
            jsonOption.compileOnSave = true;
        }

        return parseJsonConfigFileContentOld.apply(this, arguments)
    }

    return true;
}