/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.appServerIntegration;

import com.intellij.database.dataSource.DataSourceProvider;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServerIntegrations.AppServerSpecificValidator;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.applicationServer.WeblogicApplicationServerHelper;
import com.intellij.javaee.weblogic.applicationServer.WeblogicDeploymentSettingsEditor;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionConfig;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionList;
import com.intellij.javaee.weblogic.build.WebLogicValidatorsFactory;
import com.intellij.javaee.weblogic.dataSource.WeblogicDataSourceProviderImpl;
import com.intellij.javaee.weblogic.runDebug.deployment.WLDeploymentModel;
import com.intellij.javaee.weblogic.runDebug.deployment.WeblogicDeploymentProvider;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.Function;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeblogicIntegration
extends JavaeeIntegration {
    public static WeblogicIntegration getInstance() {
        return (WeblogicIntegration)AppServerIntegrationsManager.getInstance().getIntegration(WeblogicIntegration.class);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Oracle;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = AllIcons.Providers.Oracle;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration", "getBigIcon"));
        }
        return icon;
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new WeblogicDeploymentProvider(!local);
    }

    protected void collectDescriptors(JavaeeDescriptorsManager descriptorsManager) {
    }

    @NotNull
    public String getName() {
        String string = WeblogicBundle.message("weblogic.integration.presentable.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration", "getName"));
        }
        return string;
    }

    public String getNameFromTemplate(String template) throws Exception {
        return null;
    }

    public String getVersionFromTemplate(String template) throws Exception {
        return null;
    }

    @NotNull
    public String getServerVersion(JavaeePersistentData persistentData) throws Exception {
        String home = persistentData.HOME;
        WeblogicVersionList versionList = WeblogicVersionConfig.getVersionList(persistentData);
        if (versionList.isEmpty()) {
            throw new Exception(WeblogicBundle.message("message.text.weblogic.server.configuration.directory.is.not.bea.home", home));
        }
        WeblogicVersion version = WeblogicVersionConfig.getChosenVersion(persistentData);
        if (version == null) {
            throw new Exception(WeblogicBundle.message("error.cannot.find.selected.server.version", new Object[0]));
        }
        if (!version.getJarFile().exists()) {
            throw new Exception(WeblogicBundle.message("error.cannot.find.libraries.in.path", version.getLibDir()));
        }
        String string = StringUtil.join(versionList.getVersions(), (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration", "getServerVersion"));
        }
        return string;
    }

    protected void checkValidServerHome(String home, String version) throws Exception {
    }

    protected boolean allLibrariesFound(Collection<String> classes, Function<String, String> mapper) {
        return true;
    }

    protected void addLibraryLocations(JavaeePersistentData persistentData, List<File> locations) {
        WeblogicVersion version = WeblogicVersionConfig.getChosenVersion(persistentData);
        if (version == null) {
            return;
        }
        locations.add(version.getLibDir());
    }

    protected void addLibraryLocations(String home, List<File> locations) {
        throw new UnsupportedOperationException();
    }

    public String getContextRoot(JavaeeFacet facet) {
        return null;
    }

    @Nullable
    public AppServerSpecificValidator getAppServerSpecificValidator(@NotNull JavaeeFacet facet, @NotNull ApplicationServer server) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration", "getAppServerSpecificValidator"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration", "getAppServerSpecificValidator"));
        }
        return WebLogicValidatorsFactory.createValidator(facet, server);
    }

    public AppServerSpecificValidator getAppServerSpecificValidator(@NotNull ApplicationServer server, ArtifactType artifactType, @NotNull Project project) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration", "getAppServerSpecificValidator"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration", "getAppServerSpecificValidator"));
        }
        return WebLogicValidatorsFactory.createValidator(server, artifactType, project);
    }

    public DataSourceProvider getDataSourceProvider() {
        return new WeblogicDataSourceProviderImpl();
    }

    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return new WeblogicDeploymentSettingsEditor(commonModel, source);
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new WLDeploymentModel(commonModel, source);
    }

    protected JavaeeServerHelper createServerHelper() {
        return new WeblogicApplicationServerHelper();
    }
}

