/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.configuration;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.agent.AgentClassLoaderCache;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ProcessAgentProxyFactory;
import com.intellij.javaee.oss.agent.ReflectiveThreadAgentProxyFactory;
import com.intellij.javaee.oss.server.DeploymentStatusManager;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerExtension;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.RemoteConnectionTesterBase;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.admin.WebLogic9AdminServer;
import com.intellij.javaee.weblogic.agent.WebLogicTargetType;
import com.intellij.javaee.weblogic.beaInstallation.BeaDomain;
import com.intellij.javaee.weblogic.beaInstallation.BeaServer;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicUtil;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionConfig;
import com.intellij.javaee.weblogic.module.WLDeploymentDecriptorsConstants;
import com.intellij.javaee.weblogic.runDebug.configuration.DebugParameterChecker;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicLocalRunConfigurationEditor;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicRemoteEditor;
import com.intellij.javaee.weblogic.runDebug.weblogicServerInstances.WebLogicJSPPositionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.psi.xml.XmlFile;
import com.intellij.remoteServer.agent.impl.RemoteAgentClassLoaderCache;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeblogicModel
extends JavaeeServerModel {
    private static final Logger LOG = Logger.getInstance((String)("#" + WeblogicModel.class.getName()));
    @NonNls
    private static final String DOMAIN_LOG_ID = "WEBLOGIC_DOMAIN_LOG_FILE";
    @NonNls
    private static final String SERVER_LOG_ID = "WEBLOGIC_SERVER_LOG_FILE";
    public static final int DEFAULT_PORT = 7001;
    private final AgentClassLoaderCache myAgentClassLoaderCache = new AgentClassLoaderCache();
    @NonNls
    public String DOMAIN_PATH = "";
    @NonNls
    public String SERVER_NAME = "myserver";
    @NonNls
    public String DOMAIN_NAME = "mydomain";
    @NonNls
    public String ADMIN_SERVER_HOST = "localhost";
    public int ADMIN_SERVER_PORT = 7001;
    @NonNls
    public String TARGET_TYPE_NAME = WebLogicTargetType.TYPE_SERVER.name();
    @NonNls
    public String CLUSTER_NAME = "mycluster";
    public boolean CONNECT_TO_MANAGED_SERVER = false;
    private boolean myTestDomainOnly = false;

    protected JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        boolean local = this.isLocal();
        if (local && this.CONNECT_TO_MANAGED_SERVER) {
            CommonStrategy adminModel = (CommonStrategy)this.getCommonModel().clone();
            adminModel.setLocal(false);
            ((WeblogicModel)adminModel.getServerModel()).myTestDomainOnly = true;
            Ref exceptionRef = new Ref();
            boolean adminConnected = RemoteConnectionTesterBase.testConnection((CommonModel)adminModel, (Ref)exceptionRef);
            if (!exceptionRef.isNull()) {
                LOG.debug((Throwable)exceptionRef.get());
            }
            if (!adminConnected) {
                Ref cancelRef = new Ref((Object)false);
                ApplicationManager.getApplication().invokeAndWait(() -> cancelRef.set((Object)(Messages.showYesNoDialog((Project)this.getCommonModel().getProject(), (String)WeblogicBundle.message("WeblogicModel.confirm.start.managed.without.admin", new Object[0]), (String)WeblogicBundle.message("WeblogicModel.start.managed.server", new Object[0]), (Icon)Messages.getWarningIcon()) != 0 ? 1 : 0)));
                if (((Boolean)cancelRef.get()).booleanValue()) {
                    throw new RunCanceledByUserException();
                }
            }
        }
        return new WebLogic9AdminServer((AgentProxyFactory)new ProcessAgentProxyFactory(serverInstance){

            protected void customizeParameters(JavaParameters javaParameters) {
                if (WeblogicModel.this.getParsedVersion().getMajor() == 9) {
                    javaParameters.getVMParametersList().addParametersString("-Dsun.lang.ClassLoader.allowArraySyntax=true");
                }
            }
        }, this.getLibraries(), this, local);
    }

    public JavaeeServerExtension getExtensionForDataSourceImport() {
        try {
            DeploymentStatusManager deploymentStatusManager = new DeploymentStatusManager();
            JavaeeServerInstanceImpl serverInstance = new JavaeeServerInstanceImpl(this.getCommonModel(), deploymentStatusManager);
            deploymentStatusManager.setServerInstance((J2EEServerInstance)serverInstance);
            WebLogic9AdminServer admin = new WebLogic9AdminServer((AgentProxyFactory)new ReflectiveThreadAgentProxyFactory((RemoteAgentClassLoaderCache)this.myAgentClassLoaderCache, ((Object)((Object)this)).getClass().getClassLoader()), this.getLibraries(), this, this.isLocal());
            serverInstance.setAdmin((JavaeeAdmin)admin);
            serverInstance.connect();
            if (!serverInstance.isConnected()) {
                serverInstance.disconnect();
                return null;
            }
            return serverInstance.getExtension();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public boolean isDatasourcesImportSupported() {
        return this.getParsedVersion().getMajor() >= 10;
    }

    public boolean isTestDomainOnly() {
        return this.myTestDomainOnly;
    }

    @Nullable
    public WeblogicVersion getChosenVersion() {
        ApplicationServer applicationServer = this.getCommonModel().getApplicationServer();
        if (applicationServer == null) {
            return null;
        }
        JavaeePersistentData persistentData = (JavaeePersistentData)applicationServer.getPersistentData();
        return WeblogicVersionConfig.getChosenVersion(persistentData);
    }

    protected List<File> getLibraries() {
        ArrayList<File> libraries = new ArrayList<File>();
        WeblogicVersion version = this.getChosenVersion();
        if (version != null) {
            libraries.add(version.getJarFile());
            libraries.add(version.getJMXClientJarFile());
            libraries.add(version.getXBeanJarFile());
        }
        return libraries;
    }

    public int getDefaultPort() {
        return 7001;
    }

    protected int getServerPort() {
        return this.getCommonModel().getPort();
    }

    public boolean isDetectableServerPort() {
        return false;
    }

    protected String getDefaultUsername() {
        return "weblogic";
    }

    protected String getDefaultPassword() {
        return "";
    }

    public String getAdminServerHost() {
        return this.CONNECT_TO_MANAGED_SERVER ? this.ADMIN_SERVER_HOST : this.getCommonModel().getHost();
    }

    public int getAdminServerPort() {
        return this.CONNECT_TO_MANAGED_SERVER ? this.ADMIN_SERVER_PORT : this.getCommonModel().getPort();
    }

    public WebLogicTargetType getTargetType() {
        return WebLogicTargetType.valueOf(this.TARGET_TYPE_NAME);
    }

    public void setTargetType(WebLogicTargetType targetType) {
        this.TARGET_TYPE_NAME = targetType.name();
    }

    public static boolean isVersion9OrLater(Version version) {
        return version.getMajor() >= 9;
    }

    public SettingsEditor<CommonModel> getEditor() {
        if (this.getCommonModel().isLocal()) {
            return new WeblogicLocalRunConfigurationEditor();
        }
        return new WeblogicRemoteEditor(this.getCommonModel().getProject());
    }

    public int getLocalPort() {
        BeaDomain domain = this.createDomain();
        BeaServer server = this.findOrGetFirstServer(domain);
        return server.getPort();
    }

    public int getPingPort() {
        return this.getAdminServerPort();
    }

    @NotNull
    public BeaServer findOrGetFirstServer(@NotNull BeaDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/javaee/weblogic/runDebug/configuration/WeblogicModel", "findOrGetFirstServer"));
        }
        BeaServer server = this.findServer(domain);
        if (server == null) {
            server = domain.getServers()[0];
        }
        BeaServer beaServer = server;
        if (beaServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/runDebug/configuration/WeblogicModel", "findOrGetFirstServer"));
        }
        return beaServer;
    }

    public BeaDomain createDomain() {
        return WeblogicUtil.createDomain(new File(FileUtil.toSystemDependentName((String)this.DOMAIN_PATH)));
    }

    private void checkDebuggingIsEnabled() throws RuntimeConfigurationException {
        if (this.getParsedVersion().getMajor() < 10) {
            for (DeploymentModel deploymentModel : this.getCommonModel().getDeploymentModels()) {
                this.checkDebuggingIsEnabled(deploymentModel);
            }
        }
    }

    private void checkDebuggingIsEnabled(DeploymentModel deploymentModel) throws RuntimeConfigurationException {
        Artifact artifact = deploymentModel.getArtifact();
        if (artifact == null) {
            return;
        }
        Project project = this.getCommonModel().getProject();
        Collection webFacets = JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(project, artifact, WebFacet.ID);
        for (WebFacet webFacet : webFacets) {
            String message;
            ConfigFile mainDeploymentDescriptor = webFacet.getDescriptorsContainer().getConfigFile(WLDeploymentDecriptorsConstants.WEBLOGIC_XML_META_DATA);
            if (mainDeploymentDescriptor != null) {
                message = DeploymentUtil.getInstance().getConfigFileErrorMessage(mainDeploymentDescriptor);
                if (message != null) {
                    throw new RuntimeConfigurationWarning(message);
                }
                XmlFile xmlFile = mainDeploymentDescriptor.getXmlFile();
                DebugParameterChecker checker = new DebugParameterChecker(xmlFile, project);
                if (checker.checkDebugParameter()) continue;
                RuntimeConfigurationWarning exception = new RuntimeConfigurationWarning(WeblogicModel.getCantDebugMessage(webFacet));
                exception.setQuickFix(checker.getQuickFix());
                throw exception;
            }
            message = WeblogicBundle.message("message.text.cant.debug.facet.descriptor.not.defined", webFacet.getName());
            RuntimeConfigurationWarning warning = new RuntimeConfigurationWarning(message);
            warning.setQuickFix(() -> JavaeeFacetUtil.getInstance().showFacetDescriptorsSettingsEditor((JavaeeFacet)webFacet));
            throw warning;
        }
    }

    private static String getCantDebugMessage(WebFacet webFacet) {
        return WeblogicBundle.message("message.text.cant.debug.module", webFacet.getName());
    }

    public Version getParsedVersion() {
        return new Version(this.getVersion());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!this.isLocal()) {
            this.checkDebuggingIsEnabled();
            return;
        }
        if (this.getParsedVersion().getMajor() < 7) {
            return;
        }
        this.checkDebuggingIsEnabled();
        if (this.createValidDomain() == null) {
            throw new RuntimeConfigurationWarning(WeblogicBundle.message("exception.text.domain.wasnt.correctly.specified", new Object[0]));
        }
    }

    public String getServerSpecificContext(File source) {
        return WeblogicModel.cutWarExtension((File)source);
    }

    @Nullable
    private BeaDomain createValidDomain() {
        return WeblogicUtil.createValidDomain(new File(FileUtil.toSystemDependentName((String)this.DOMAIN_PATH)));
    }

    public WeblogicModel clone() throws CloneNotSupportedException {
        return (WeblogicModel)((Object)super.clone());
    }

    @Nullable
    private BeaServer findServer(@Nullable BeaDomain beaDomain) {
        if (beaDomain == null) {
            return null;
        }
        for (BeaServer server : beaDomain.getServers()) {
            if (!this.SERVER_NAME.equals(server.getName())) continue;
            return server;
        }
        return null;
    }

    protected List<JavaeeServerModel.LogFileFactory> getLogFileFactories() {
        return Arrays.asList(new JavaeeServerModel.LogFileFactory[]{new WeblogicDomainLogFileFactory(), new WeblogicServerLogFileFactory()});
    }

    protected String getLogFileId() {
        throw new UnsupportedOperationException();
    }

    protected PositionManager createPositionManager(DebugProcess process, JavaeeFacet[] scopeFacetsWithIncluded) {
        return new WebLogicJSPPositionManager(process, scopeFacetsWithIncluded);
    }

    private class WeblogicServerLogFileFactory
    extends WeblogicLogFileFactory {
        private WeblogicServerLogFileFactory() {
        }

        protected String getId() {
            return WeblogicModel.SERVER_LOG_ID;
        }

        protected String getName() {
            return WeblogicModel.this.SERVER_NAME;
        }

        @Override
        protected File getLogFile(BeaDomain domain, BeaServer server) {
            return server.getLogFile();
        }
    }

    private class WeblogicDomainLogFileFactory
    extends WeblogicLogFileFactory {
        private WeblogicDomainLogFileFactory() {
        }

        protected String getId() {
            return WeblogicModel.DOMAIN_LOG_ID;
        }

        protected String getName() {
            return WeblogicBundle.message("log.file.alias.domain.log", new Object[0]);
        }

        @Override
        protected File getLogFile(BeaDomain domain, BeaServer server) {
            return domain.getDomainLogFile();
        }
    }

    private abstract class WeblogicLogFileFactory
    extends JavaeeServerModel.LogFileFactory {
        private WeblogicLogFileFactory() {
        }

        protected String getPath() {
            BeaDomain domain = WeblogicModel.this.createValidDomain();
            if (domain == null) {
                return null;
            }
            BeaServer server = WeblogicModel.this.findServer(domain);
            if (server == null) {
                return null;
            }
            File logFile = this.getLogFile(domain, server);
            return logFile.exists() ? logFile.getAbsolutePath() : null;
        }

        protected abstract File getLogFile(BeaDomain var1, BeaServer var2);
    }
}

