/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.GroovyMvcIcons;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsGradleAwareModuleBuilder;
import org.jetbrains.plugins.grails.config.GrailsOptionsWizardStep;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.runner.GrailsInstallationExecutor;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsModuleBuilder
extends GrailsGradleAwareModuleBuilder {
    private static final Logger LOG = Logger.getInstance(GrailsModuleBuilder.class);
    private GrailsSDK myGrailsSDK;
    @NotNull
    private String myCreationChoice = "create-app";
    @Nullable
    private String myOptions;

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        if (this.myJdk != null) {
            modifiableRootModel.setSdk(this.myJdk);
        } else {
            modifiableRootModel.inheritSdk();
        }
        if (this.doAddContentEntry(modifiableRootModel) == null) {
            throw new ConfigurationException("Cannot setup root path");
        }
    }

    @Override
    protected void setupModule(@NotNull Module module) throws ConfigurationException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "setupModule"));
        }
        super.setupModule(module);
        Project project = module.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "lambda$setupModule$0"));
            }
            try {
                GrailsConsole.getInstance(project);
                this.doSetupModule(module);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                GrailsConsole.NOTIFICATION_GROUP.createNotification("Failed to create Grails app structure", String.valueOf(e.getMessage()), NotificationType.WARNING, null).notify(project);
            }
        });
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new GrailsOptionsWizardStep(context, this);
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return "Grails";
    }

    public String getDescription() {
        return "Grails application module builder";
    }

    public Icon getNodeIcon() {
        return GroovyMvcIcons.Grails;
    }

    public String getParentGroup() {
        return "Groovy";
    }

    public void setGrailsSDKHome(GrailsSDK grailsSDK) {
        this.myGrailsSDK = grailsSDK;
    }

    public void setCreateChoice(@NotNull String creationChoice) {
        if (creationChoice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creationChoice", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "setCreateChoice"));
        }
        this.myCreationChoice = creationChoice;
    }

    public void setOptions(@Nullable String options) {
        this.myOptions = StringUtil.isEmptyOrSpaces((String)options) ? null : options;
    }

    private void doSetupModule(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "doSetupModule"));
        }
        Project project = module.getProject();
        VirtualFile rootModuleContent = this.getModuleRoot(module);
        GrailsSDKManager.getInstance(project).setGrailsSDK(rootModuleContent.getPath(), this.myGrailsSDK.getPath());
        GeneralCommandLine parameters = this.getCreationCommandLine(module);
        Consumer<Module> linker = this.myGrailsSDK.getVersion().isAtLeast(Version.GRAILS_3_0) ? this::linkModule : null;
        Runnable onDone = () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "lambda$doSetupModule$1"));
            }
            LOG.debug("Grails application structure created for module: " + module);
            if (linker != null) {
                linker.accept(module);
            }
        };
        GrailsConsole.executeProcess(project, parameters, onDone, false, new String[0]);
    }

    @NotNull
    private GeneralCommandLine getCreationCommandLine(@NotNull Module module) throws ExecutionException {
        Sdk sdk;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getCreationCommandLine"));
        }
        Project project = module.getProject();
        VirtualFile root = this.getModuleRoot(module);
        MvcCommand command = new MvcCommand(this.myCreationChoice, new String[]{root.getName(), "--inplace"});
        if (this.myOptions != null) {
            ContainerUtil.addAll((Collection)command.getArgs(), (Object[])this.myOptions.split(" "));
        }
        Sdk sdk2 = sdk = this.getModuleJdk() == null ? ProjectRootManager.getInstance((Project)project).getProjectSdk() : this.getModuleJdk();
        if (sdk == null) {
            throw new ExecutionException("SDK is not defined");
        }
        JavaParameters params = this.getExecutor().createJavaParameters(sdk, this.myGrailsSDK, command);
        params.setWorkingDirectory(root.getPath());
        params.setDefaultCharset(project);
        GeneralCommandLine parameters = params.toCommandLine();
        LOG.debug(parameters.getCommandLineString());
        GeneralCommandLine generalCommandLine = parameters;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getCreationCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private GrailsInstallationExecutor getExecutor() throws ExecutionException {
        for (GrailsCommandExecutor executor : (GrailsCommandExecutor[])GrailsCommandExecutor.EP_NAME.getExtensions()) {
            GrailsInstallationExecutor installationExecutor;
            if (!(executor instanceof GrailsInstallationExecutor) || !(installationExecutor = (GrailsInstallationExecutor)((Object)executor)).isApplicable(this.myGrailsSDK)) continue;
            GrailsInstallationExecutor grailsInstallationExecutor = installationExecutor;
            if (grailsInstallationExecutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getExecutor"));
            }
            return grailsInstallationExecutor;
        }
        throw new ExecutionException("Cannot create application with Grails SDK: " + this.myGrailsSDK.getPath());
    }
}

