/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.tests.GrailsTestUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GenerateTestsAction
extends AnAction {
    private final boolean myIntegration;
    private final String myArtifactName;
    private final GrailsArtifact myArtifactType;

    public GenerateTestsAction(boolean integration, @NotNull String artifactName, GrailsArtifact artifactType) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/plugins/grails/editor/GenerateTestsAction", "<init>"));
        }
        this.myIntegration = integration;
        this.myArtifactName = artifactName;
        this.myArtifactType = artifactType;
    }

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)e.getData(DataKeys.MODULE);
        if (module == null) {
            return;
        }
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        if (application == null) {
            return;
        }
        PsiClass testedClass = this.getTestedClass(module);
        if (testedClass == null) {
            switch (this.myArtifactType) {
                case DOMAIN: {
                    Messages.showErrorDialog((String)GrailsBundle.message("generate.domain.class.first", this.myArtifactName), (String)GrailsBundle.message("no.domain.class.found", new Object[0]));
                    break;
                }
                case CONTROLLER: {
                    Messages.showErrorDialog((String)GrailsBundle.message("generate.controller.first", this.myArtifactName), (String)GrailsBundle.message("no.controller.found", new Object[0]));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return;
        }
        String qualifiedName = testedClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        MvcCommand mvcCommand = new MvcCommand(this.myIntegration ? "create-integration-test" : "create-unit-test", new String[]{qualifiedName});
        GrailsCommandExecutorUtil.execute(application, mvcCommand, () -> {
            if (!testedClass.isValid()) {
                return;
            }
            PsiClass testClass = this.findTestClass(testedClass);
            if (testClass != null) {
                testClass.navigate(true);
            }
        }, true, new String[0]);
    }

    @Nullable
    private PsiClass findTestClass(PsiClass testedClass) {
        for (PsiClass aClass : GrailsTestUtils.getTestsForArtifact(testedClass, true)) {
            String testType = GrailsTestUtils.getTestType(aClass);
            if (!(this.myIntegration ? "integration".equals(testType) : "unit".equals(testType))) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private PsiClass getTestedClass(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/editor/GenerateTestsAction", "getTestedClass"));
        }
        Collection<GrClassDefinition> instances = this.myArtifactType.getInstances(module, this.myArtifactName);
        if (instances.isEmpty()) {
            return null;
        }
        return (PsiClass)instances.iterator().next();
    }

    private boolean isEnabled(AnActionEvent e) {
        Module module = (Module)e.getData(DataKeys.MODULE);
        if (module == null || !GrailsUtils.hasSupport(module)) {
            return false;
        }
        PsiClass testedClass = this.getTestedClass(module);
        if (testedClass == null) {
            return false;
        }
        return this.findTestClass(testedClass) == null;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        super.update(e);
        if (!presentation.isEnabled()) {
            return;
        }
        if (!this.isEnabled(e)) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }
}

