/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gradle;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.gradle.GrailsModuleData;
import org.jetbrains.plugins.grails.gradle.tooling.builder.GrailsModule;
import org.jetbrains.plugins.grails.gradle.tooling.builder.GrailsModuleModelBuilderImpl;

@Order(value=1000)
public class GrailsProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(GrailsProjectResolverExtension.class);
    private static final String GRAILS_TASK_PREFIX = "grails-";

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension", "populateModuleExtraModels"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension", "populateModuleExtraModels"));
        }
        GrailsModule grailsModule = (GrailsModule)this.resolverCtx.getExtraProject(gradleModule, GrailsModule.class);
        if (grailsModule != null) {
            ideModule.createChild(GrailsModuleData.KEY, (Object)new GrailsModuleData(GradleConstants.SYSTEM_ID, grailsModule.getGrailsVersion(), grailsModule.getGrailsPluginId(), grailsModule.getShellUrls()));
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set<Class> set = Collections.singleton(GrailsModule.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension", "getExtraProjectModelClasses"));
        }
        return set;
    }

    @NotNull
    public Set<Class> getToolingExtensionsClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{GrailsModuleModelBuilderImpl.class, GrailsRtMarker.class});
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension", "getToolingExtensionsClasses"));
        }
        return set;
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) throws ExecutionException {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension", "enhanceRemoteProcessing"));
        }
        parameters.getClassPath().add(PathUtil.getJarPathForClass(GrailsRtMarker.class));
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String debuggerSetup, @NotNull Consumer<String> initScriptConsumer) {
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension", "enhanceTaskProcessing"));
        }
        if (initScriptConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initScriptConsumer", "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension", "enhanceTaskProcessing"));
        }
        String grailsTask = (String)ContainerUtil.find(taskNames, taskName -> taskName != null && StringUtil.startsWith((CharSequence)taskName, (CharSequence)GRAILS_TASK_PREFIX));
        if (grailsTask == null) {
            return;
        }
        if (taskNames.contains("grails-test-app")) {
            String grailsRtPath = PathUtil.getCanonicalPath((String)PathUtil.getJarPathForClass(GrailsRtMarker.class));
            String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task.hasProperty('group') && 'grails'.equals(task?.group)) {", "       if (task.hasProperty('command') && task?.command.equals('test-app')) {", "           task.runtimeClasspath += files(\"" + grailsRtPath + "\")", "           task.jvmOptions.jvmArgs('-Dgrails.build.listeners=org.jetbrains.groovy.grails.rt.GrailsIdeaTestListener')", "       }    }}"};
            String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
            initScriptConsumer.consume((Object)script);
        }
        if (!StringUtil.isEmpty((String)debuggerSetup)) {
            String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task.hasProperty('group') && 'grails'.equals(task?.group)) {", "        if (task.hasProperty('jvmOptions') && task?.jvmOptions instanceof JavaForkOptions) {", "            task.jvmOptions.jvmArgs = ['" + debuggerSetup.trim() + "' , *task.jvmOptions.jvmArgs]", "       }    }}"};
            String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
            initScriptConsumer.consume((Object)script);
        }
    }
}

