/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.completion;

import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlFileNSInfoProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.GspTagLibUtil;

public class GspXmlFileNSInfoProvider
implements XmlFileNSInfoProvider,
Function<String, String[]> {
    private static final String[][] HTML_PREFIXES = new String[][]{{"", "http://www.w3.org/1999/xhtml"}};

    @Nullable
    public String[][] getDefaultNamespaces(@NotNull XmlFile file) {
        Language baseLanguage;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/lang/gsp/completion/GspXmlFileNSInfoProvider", "getDefaultNamespaces"));
        }
        if (file instanceof GspFile) {
            return (String[][])ContainerUtil.map2Array(GspTagLibUtil.getTagLibClasses((PsiElement)file).keySet(), String[].class, (Function)this);
        }
        FileViewProvider viewProvider = file.getViewProvider();
        if (viewProvider instanceof GspFileViewProvider && viewProvider.getFileType() == GspFileType.GSP_FILE_TYPE && ((baseLanguage = ((GspFileViewProvider)viewProvider).getTemplateDataLanguage()) == StdLanguages.HTML || baseLanguage == StdLanguages.XHTML)) {
            return HTML_PREFIXES;
        }
        return null;
    }

    public boolean overrideNamespaceFromDocType(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/lang/gsp/completion/GspXmlFileNSInfoProvider", "overrideNamespaceFromDocType"));
        }
        return false;
    }

    public String[] fun(String s2) {
        return new String[]{s2, s2};
    }
}

