/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.reference.contributor;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.GrailsPatterns;

public class GspCssClassReferenceContributor
extends PsiReferenceContributor {
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("\\S+");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/reference/contributor/GspCssClassReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)GrailsPatterns.gspAttributeValue((ElementPattern<? extends XmlAttribute>)XmlPatterns.xmlAttribute((String)"class").withParent((ElementPattern)XmlPatterns.xmlTag().withNamespace("g"))), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/reference/contributor/GspCssClassReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/reference/contributor/GspCssClassReferenceContributor$1", "getReferencesByElement"));
                }
                if (!(element instanceof XmlAttributeValue)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/reference/contributor/GspCssClassReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                ArrayList<PsiReference> res = new ArrayList<PsiReference>();
                CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)element);
                if (descriptorProvider == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/reference/contributor/GspCssClassReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!PsiImplUtil.isLeafElementOfType((PsiElement)child, (IElementType)XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN)) continue;
                    Matcher matcher = CLASS_NAME_PATTERN.matcher(child.getText());
                    while (matcher.find()) {
                        int offsetChild = child.getStartOffsetInParent();
                        res.add(descriptorProvider.getStyleReference(element, offsetChild + matcher.start(), offsetChild + matcher.end(), false));
                    }
                }
                PsiReference[] psiReferenceArray = res.toArray(new PsiReference[res.size()]);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/reference/contributor/GspCssClassReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }
}

