/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives.graph;

import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.perspectives.create.CreateNewRelation;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;

public class DomainClassesRelationsDataModel
extends GraphDataModel<DomainClassNode, DomainClassRelationsInfo> {
    private Set<DomainClassNode> myNodes = new HashSet();
    private Set<DomainClassRelationsInfo> myEdges = new HashSet();
    private final Project myProject;
    private final VirtualFile myDomainDirectory;
    private Map<DomainClassNode, List<DomainClassRelationsInfo>> myNodesToOutsMap;

    public DomainClassesRelationsDataModel(@Nullable VirtualFile domainDirectory, Project project) {
        this.myDomainDirectory = domainDirectory;
        this.myProject = project;
    }

    public Map<DomainClassNode, List<DomainClassRelationsInfo>> getNodesToOutsMap() {
        return this.myNodesToOutsMap;
    }

    @NotNull
    public Collection<DomainClassNode> getNodes() {
        this.refreshDataModel();
        Set<DomainClassNode> set = this.myNodes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel", "getNodes"));
        }
        return set;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void updateDataModel() {
        this.myNodesToOutsMap = DomainClassUtils.buildNodesAndEdges(this.myProject, this.myDomainDirectory);
        this.myNodes = this.myNodesToOutsMap.keySet();
        this.myEdges = new HashSet((Collection)ContainerUtil.flatten(this.myNodesToOutsMap.values()));
    }

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    @NotNull
    public Collection<DomainClassRelationsInfo> getEdges() {
        this.refreshDataModel();
        Set<DomainClassRelationsInfo> set = this.myEdges;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel", "getEdges"));
        }
        return set;
    }

    @NotNull
    public DomainClassNode getSourceNode(DomainClassRelationsInfo domainClassRelationsInfo) {
        DomainClassNode domainClassNode = domainClassRelationsInfo.getSource();
        if (domainClassNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel", "getSourceNode"));
        }
        return domainClassNode;
    }

    @NotNull
    public DomainClassNode getTargetNode(DomainClassRelationsInfo domainClassRelationsInfo) {
        DomainClassNode domainClassNode = domainClassRelationsInfo.getTarget();
        if (domainClassNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel", "getTargetNode"));
        }
        return domainClassNode;
    }

    @NotNull
    public String getNodeName(DomainClassNode domainClassNode) {
        String string = domainClassNode.getUniqueName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel", "getNodeName"));
        }
        return string;
    }

    @NotNull
    public String getEdgeName(DomainClassRelationsInfo domainClassRelationsInfo) {
        String string = domainClassRelationsInfo.getEdgeLabel();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel", "getEdgeName"));
        }
        return string;
    }

    public DomainClassRelationsInfo createEdge(@NotNull DomainClassNode source, @NotNull DomainClassNode target) {
        int exitCode;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel", "createEdge"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel", "createEdge"));
        }
        PsiClass targetClass = target.getTypeDefinition();
        String targetQualifiedName = targetClass.getQualifiedName();
        PsiClass psiClass = source.getTypeDefinition();
        String sourceQualifiedName = psiClass.getQualifiedName();
        if (sourceQualifiedName != null && sourceQualifiedName.contains(".") && targetQualifiedName != null && !targetQualifiedName.contains(".") && (exitCode = Messages.showDialog((Project)this.myProject, (String)GrailsBundle.message("destination.class.cannot.be.resolved", new Object[0]), (String)GrailsBundle.message("Warning", new Object[0]), (String[])new String[]{"OK", "Cancel"}, (int)1, (Icon)Messages.getWarningIcon())) == 1) {
            return null;
        }
        CreateNewRelation dialogWrapper = new CreateNewRelation(source, target, this.myProject);
        dialogWrapper.show();
        DomainClassRelationsInfo.Relation relationType = dialogWrapper.getEdgeRelationType();
        if (relationType != null && DomainClassRelationsInfo.Relation.UNKNOWN != relationType) {
            this.myEdges.add(new DomainClassRelationsInfo(source, target, relationType));
        }
        return new DomainClassRelationsInfo(source, target, relationType);
    }

    public void dispose() {
    }

    public Project getProject() {
        return this.myProject;
    }
}

