/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.pluginSupport.resources;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.pluginSupport.resources.GrailsResourceModuleReference;
import org.jetbrains.plugins.grails.references.GrailsMethodNamedArgumentReferenceProvider;
import org.jetbrains.plugins.grails.references.common.GrailsFileReferenceSetBase;
import org.jetbrains.plugins.grails.util.SafeReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GrailsResourcesReferenceProvider
implements GrailsMethodNamedArgumentReferenceProvider.Contributor {
    @Override
    public void register(GrailsMethodNamedArgumentReferenceProvider registrar) {
        GrailsMethodNamedArgumentReferenceProvider.Contributor.ClassNameCondition classNameCondition = new GrailsMethodNamedArgumentReferenceProvider.Contributor.ClassNameCondition("org.grails.plugin.resource.module.ModuleBuilder");
        registrar.register((Object)-1, ResourceModuleReferenceProvider.class, (Condition<PsiMethod>)classNameCondition, "dependsOn");
        registrar.register((Object)0, ResourceUrlReferenceProvider.class, (Condition<PsiMethod>)classNameCondition, "resource");
        registrar.register((Object)"url", ResourceUrlReferenceProvider.class, (Condition<PsiMethod>)classNameCondition, "resource");
    }

    public static class ResourceModuleReferenceProvider
    extends GrailsMethodNamedArgumentReferenceProvider.Contributor.Provider {
        private static final LightCacheKey<PsiReference[]> KEY = LightCacheKey.create();
        private static final Pattern ourPattern = Pattern.compile("[^\\s,]+");

        public static PsiReference[] createManyModuleReferences(@NotNull PsiElement element, @NotNull String value, int offset) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceModuleReferenceProvider", "createManyModuleReferences"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceModuleReferenceProvider", "createManyModuleReferences"));
            }
            PsiReference[] cachedValue = (PsiReference[])KEY.getCachedValue(element);
            if (cachedValue != null) {
                return cachedValue;
            }
            ArrayList<GrailsResourceModuleReference> res = new ArrayList<GrailsResourceModuleReference>();
            Matcher matcher = ourPattern.matcher(value);
            while (matcher.find()) {
                TextRange range = new TextRange(offset + matcher.start(), offset + matcher.end());
                res.add(new GrailsResourceModuleReference(element, range, false));
            }
            PsiReference[] resArray = res.toArray(new PsiReference[res.size()]);
            SafeReference.makeReferencesSafe(resArray);
            resArray = (PsiReference[])KEY.putCachedValue(element, (Object)resArray);
            return resArray;
        }

        @Override
        public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrMethodCall methodCall, int argumentIndex, @NotNull GroovyResolveResult method) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceModuleReferenceProvider", "createRef"));
            }
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceModuleReferenceProvider", "createRef"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceModuleReferenceProvider", "createRef"));
            }
            GrLiteralImpl literal = (GrLiteralImpl)element;
            String value = (String)literal.getValue();
            assert (value != null);
            if (value.contains(",")) {
                int startInElement = GroovyStringLiteralManipulator.getLiteralRange((String)element.getText()).getStartOffset();
                return ResourceModuleReferenceProvider.createManyModuleReferences(element, value, startInElement);
            }
            return new PsiReference[]{new GrailsResourceModuleReference(element, false)};
        }
    }

    public static class ResourceUrlReferenceProvider
    extends GrailsMethodNamedArgumentReferenceProvider.Contributor.Provider {
        @Override
        protected PsiReference[] createRef(@NotNull PsiElement element, @NotNull GroovyResolveResult method) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceUrlReferenceProvider", "createRef"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceUrlReferenceProvider", "createRef"));
            }
            String text = element.getText();
            assert (element instanceof GrLiteralImpl);
            TextRange range = GroovyStringLiteralManipulator.getLiteralRange((String)text);
            String value = range.substring(text);
            if (value.contains(":/")) {
                return PsiReference.EMPTY_ARRAY;
            }
            VirtualFile root = GrailsFramework.getInstance().findAppRoot(element);
            if (root == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            final VirtualFile webApp = root.findChild("web-app");
            if (webApp == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            GrailsFileReferenceSetBase set = new GrailsFileReferenceSetBase(value, element, range.getStartOffset(), null, true, true){

                @Override
                protected VirtualFile getDefaultContext(boolean isAbsolute) {
                    return webApp;
                }
            };
            return set.getAllReferences();
        }
    }
}

