/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;

public class GrailsLayoutFileReferenceSet
extends FileReferenceSet {
    private final VirtualFile myLayoutDir;

    public GrailsLayoutFileReferenceSet(@NotNull String trimedUrl, @NotNull PsiElement element, int offset, @NotNull VirtualFile layoutDir) {
        if (trimedUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trimedUrl", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet", "<init>"));
        }
        if (layoutDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutDir", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet", "<init>"));
        }
        super(trimedUrl, element, offset, null, true, false);
        this.myLayoutDir = layoutDir;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return new Condition<PsiFileSystemItem>(){
            private final ProjectFileIndex fileIndex;
            {
                this.fileIndex = ProjectRootManager.getInstance((Project)GrailsLayoutFileReferenceSet.this.getElement().getProject()).getFileIndex();
            }

            public boolean value(PsiFileSystemItem psiFileSystemItem) {
                VirtualFile file = psiFileSystemItem.getVirtualFile();
                if (file == null || !this.fileIndex.isInContent(file)) {
                    return false;
                }
                return !(psiFileSystemItem instanceof PsiFile) || ((PsiFile)psiFileSystemItem).getViewProvider() instanceof GspFileViewProvider;
            }
        };
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new LayoutFileReference(this, range, index, text);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiDirectory directory = this.getElement().getManager().findDirectory(this.myLayoutDir);
        List<Object> list = directory == null ? Collections.emptyList() : Collections.singletonList(directory);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet", "computeDefaultContexts"));
        }
        return list;
    }

    public static PsiReference[] createReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet", "createReferences"));
        }
        VirtualFile layoutDir = VfsUtil.findRelativeFile((VirtualFile)GrailsFramework.getInstance().findAppDirectory(element), (String[])new String[]{"views", "layouts"});
        if (layoutDir == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        String trimedUrl = PathReference.trimPath((String)text);
        GrailsLayoutFileReferenceSet set = new GrailsLayoutFileReferenceSet(trimedUrl, element, offset, layoutDir);
        return set.getAllReferences();
    }

    private static class LayoutFileReference
    extends FileReference {
        public LayoutFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet$LayoutFileReference", "<init>"));
            }
            super(fileReferenceSet, range, index, text);
        }

        public void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result2, boolean caseSensitive) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet$LayoutFileReference", "innerResolveInContext"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet$LayoutFileReference", "innerResolveInContext"));
            }
            super.innerResolveInContext(this.isLast() && !text.endsWith(".gsp") ? text + ".gsp" : text, context, result2, caseSensitive);
        }

        public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet$LayoutFileReference", "bindToElement"));
            }
            PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
            VirtualFile dstVFile = fileSystemItem.getVirtualFile();
            if (dstVFile == null) {
                throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
            }
            VirtualFile layoutDir = ((GrailsLayoutFileReferenceSet)this.getFileReferenceSet()).myLayoutDir;
            String path = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)layoutDir, (char)'/');
            if (path == null) {
                return this.getElement();
            }
            path = StringUtil.trimEnd((String)path, (String)".gsp");
            return this.rename(path);
        }

        protected Object createLookupItem(PsiElement candidate) {
            if (candidate instanceof GspFile) {
                PsiFile file = (PsiFile)candidate;
                String templateName = StringUtil.trimEnd((String)file.getName(), (String)".gsp");
                return LookupElementBuilder.create((String)templateName).withIcon(file.getIcon(0));
            }
            return super.createLookupItem(candidate);
        }
    }
}

