/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class PluginReference
extends PsiReferenceBase<PsiElement> {
    private final Module myModule;

    public PluginReference(@NotNull Module module, PsiElement element, boolean soft) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/references/common/PluginReference", "<init>"));
        }
        super(element, soft);
        this.myModule = module;
    }

    public PsiElement resolve() {
        String text = this.getValue();
        VirtualFile virtualFile = GrailsFramework.getInstance().findPluginRoot(this.myModule, text, false);
        if (virtualFile == null) {
            return null;
        }
        return this.getElement().getManager().findDirectory(virtualFile);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = GrailsUtils.createPluginVariants(this.myModule, false);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginReference", "getVariants"));
        }
        return objectArray;
    }

    public static class Provider
    extends PsiReferenceProvider {
        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/PluginReference$Provider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/common/PluginReference$Provider", "getReferencesByElement"));
            }
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginReference$Provider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new PluginReference(module, element, false)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginReference$Provider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    }
}

