/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.common.PluginSupportFileReferenceSet;
import org.jetbrains.plugins.grails.references.common.WebAppFolderFileReferenceSet;

public abstract class ResourceDirAttributeFileReferenceSet
extends WebAppFolderFileReferenceSet {
    public ResourceDirAttributeFileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "<init>"));
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed);
    }

    @Nullable
    protected abstract PsiElement getPluginElement();

    @Nullable
    protected abstract PsiElement getContextPathElement();

    @Nullable
    protected static FileReference extractReference(@Nullable PsiElement contextElement) {
        if (contextElement != null) {
            for (PsiReference ref : contextElement.getReferences()) {
                if (!(ref instanceof FileReference)) continue;
                return ((FileReference)ref).getLastFileReference();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiElement pluginElement = this.getPluginElement();
        if (pluginElement != null) {
            PsiReference pluginRef = pluginElement.getReference();
            if (pluginRef == null) {
                Set<PsiFileSystemItem> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "computeDefaultContexts"));
                }
                return set;
            }
            PsiElement psiPluginRoot = pluginRef.resolve();
            if (!(psiPluginRoot instanceof PsiDirectory)) {
                Set<PsiFileSystemItem> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "computeDefaultContexts"));
                }
                return set;
            }
            VirtualFile pluginContext = this.getContextInPlugin(((PsiDirectory)psiPluginRoot).getVirtualFile());
            if (pluginContext == null) {
                Set<PsiFileSystemItem> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "computeDefaultContexts"));
                }
                return set;
            }
            PsiDirectory directory = psiPluginRoot.getManager().findDirectory(pluginContext);
            if (directory == null) {
                Set<PsiFileSystemItem> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "computeDefaultContexts"));
                }
                return set;
            }
            Set<PsiDirectory> set = Collections.singleton(directory);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "computeDefaultContexts"));
            }
            return set;
        }
        ArrayList<PsiFileSystemItem> res = new ArrayList<PsiFileSystemItem>();
        FileReference contextPathRef = ResourceDirAttributeFileReferenceSet.extractReference(this.getContextPathElement());
        if (contextPathRef != null) {
            if (contextPathRef instanceof PluginSupportFileReferenceSet.PluginDirReference) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "computeDefaultContexts"));
                }
                return list;
            }
            for (ResolveResult resolveResult : contextPathRef.multiResolve(false)) {
                PsiElement item = resolveResult.getElement();
                if (!(item instanceof PsiFileSystemItem)) continue;
                res.add((PsiFileSystemItem)item);
            }
            ArrayList<PsiFileSystemItem> arrayList = res;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "computeDefaultContexts"));
            }
            return arrayList;
        }
        Collection<PsiFileSystemItem> collection = super.computeDefaultContexts();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ResourceDirAttributeFileReferenceSet", "computeDefaultContexts"));
        }
        return collection;
    }
}

