/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.references.common.PluginSupportFileReferenceSet;

public class WebAppFolderFileReferenceSet
extends PluginSupportFileReferenceSet {
    public WebAppFolderFileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/plugins/grails/references/common/WebAppFolderFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/WebAppFolderFileReferenceSet", "<init>"));
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, true);
    }

    @Override
    protected boolean isPluginMustHasVersion() {
        return true;
    }

    @Override
    protected VirtualFile getContextInPlugin(@NotNull VirtualFile pluginRoot) {
        if (pluginRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginRoot", "org/jetbrains/plugins/grails/references/common/WebAppFolderFileReferenceSet", "getContextInPlugin"));
        }
        return pluginRoot.findChild("web-app");
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        VirtualFile rootDir = GrailsFramework.getInstance().findAppRoot(this.getElement());
        if (rootDir == null) {
            Set<PsiFileSystemItem> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/WebAppFolderFileReferenceSet", "computeDefaultContexts"));
            }
            return set;
        }
        VirtualFile webApp = rootDir.findChild("web-app");
        if (webApp == null) {
            Set<PsiFileSystemItem> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/WebAppFolderFileReferenceSet", "computeDefaultContexts"));
            }
            return set;
        }
        PsiDirectory psiDirectory = this.getElement().getManager().findDirectory(webApp);
        if (psiDirectory == null) {
            Set<PsiFileSystemItem> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/WebAppFolderFileReferenceSet", "computeDefaultContexts"));
            }
            return set;
        }
        Set<PsiDirectory> set = Collections.singleton(psiDirectory);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/WebAppFolderFileReferenceSet", "computeDefaultContexts"));
        }
        return set;
    }
}

