/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.DomainMembersProvider;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameGrFieldProcessor;

public class DomainFieldRenameProcessor
extends RenameGrFieldProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/domain/DomainFieldRenameProcessor", "canProcessElement"));
        }
        if (!(element instanceof GrField)) {
            return false;
        }
        GrField field = (GrField)element;
        PsiClass domainClass = field.getContainingClass();
        if (!GormUtils.isGormBean(domainClass)) {
            return false;
        }
        assert (domainClass != null);
        return DomainDescriptor.getPersistentProperties(domainClass).containsKey(field.getName());
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        final ArrayList<PsiReference> res = new ArrayList<PsiReference>();
        res.addAll(super.findReferences(element));
        final GrField field = (GrField)element;
        PsiClass domainClass = field.getContainingClass();
        assert (domainClass != null);
        String name = field.getName();
        assert (name != null);
        final String capName = StringUtil.capitalize((String)name);
        SearchScope useScope = domainClass.getUseScope();
        DomainDescriptor descriptor = DomainDescriptor.getDescriptor(domainClass);
        if (descriptor.getHasMany().containsKey(name)) {
            for (PsiMethod method : descriptor.getAddToAndRemoveFromMethods()) {
                String methodName = method.getName();
                if (!methodName.endsWith(capName)) continue;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)method, (SearchScope)useScope).findAll()) {
                    GrReferenceExpression grRef;
                    PsiElement nameElement;
                    if (!(reference instanceof GrReferenceExpression) || (nameElement = (grRef = (GrReferenceExpression)reference).getReferenceNameElement()) == null || !methodName.equals(nameElement.getText())) continue;
                    TextRange range = TextRange.from((int)(nameElement.getStartOffsetInParent() + methodName.length() - capName.length()), (int)capName.length());
                    res.add((PsiReference)new FinderMethodFieldReference(grRef, range, field));
                }
            }
        }
        ReferencesSearch.search((PsiElement)domainClass, (SearchScope)useScope, (boolean)false).forEach((Processor)new Processor<PsiReference>(){

            private void processReference(PsiReference psiReference) {
                if (!(psiReference instanceof GrReferenceExpression)) {
                    return;
                }
                PsiElement parent = ((GrReferenceExpression)psiReference).getParent();
                if (!(parent instanceof GrReferenceExpression)) {
                    return;
                }
                PsiElement methodCall = parent.getParent();
                if (!(methodCall instanceof GrMethodCall)) {
                    return;
                }
                GrReferenceExpression parentRef = (GrReferenceExpression)parent;
                if (parentRef.getDotTokenType() != GroovyTokenTypes.mDOT) {
                    return;
                }
                DomainClassUtils.FinderMethod finderMethod = DomainClassUtils.parseFinderMethod(parentRef.getReferenceName());
                if (finderMethod == null) {
                    return;
                }
                boolean hasProperty = false;
                for (DomainClassUtils.Condition condition : finderMethod.getConditions()) {
                    if (!condition.getFieldName().equals(capName)) continue;
                    hasProperty = true;
                    break;
                }
                if (!hasProperty) {
                    return;
                }
                PsiMethod method = ((GrMethodCall)methodCall).resolveMethod();
                if (!GrLightMethodBuilder.checkKind((PsiElement)method, (Object)DomainMembersProvider.FINDER_METHOD_MARKER)) {
                    return;
                }
                PsiElement nameElement = parentRef.getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                int i = finderMethod.getPrefix().length();
                for (DomainClassUtils.Condition condition : finderMethod.getConditions()) {
                    if (!condition.getFieldName().equals(capName)) continue;
                    res.add(new FinderMethodFieldReference(parentRef, TextRange.from((int)(nameElement.getStartOffsetInParent() + i), (int)capName.length()), field));
                    i += condition.getLength();
                    if (finderMethod.getOperator() == null) continue;
                    i += finderMethod.getOperator().length();
                }
            }

            public boolean process(PsiReference psiReference) {
                this.processReference(psiReference);
                return true;
            }
        });
        ArrayList<PsiReference> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/DomainFieldRenameProcessor", "findReferences"));
        }
        return arrayList;
    }

    public void renameElement(PsiElement psiElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        ArrayList<UsageInfo> usagesList = new ArrayList<UsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            PsiReference psiReference = usage.getReference();
            if (psiReference instanceof FinderMethodFieldReference) {
                GrReferenceExpression ref = (GrReferenceExpression)psiReference.getElement();
                PsiField field = (PsiField)psiReference.resolve();
                assert (field != null);
                String oldCapName = StringUtil.capitalize((String)field.getName());
                String newCapName = StringUtil.capitalize((String)newName);
                String oldMethodName = ref.getReferenceName();
                assert (oldMethodName != null);
                if (DomainFieldRenameProcessor.isAddToOrRemoveFromName(oldMethodName, oldCapName)) {
                    ref.handleElementRename(oldMethodName.substring(0, oldMethodName.length() - oldCapName.length()) + newCapName);
                    continue;
                }
                DomainClassUtils.FinderMethod finderMethod = DomainClassUtils.parseFinderMethod(oldMethodName);
                if (finderMethod == null) continue;
                for (DomainClassUtils.Condition condition : finderMethod.getConditions()) {
                    if (!condition.getFieldName().equals(oldCapName)) continue;
                    condition.setFieldName(newCapName);
                }
                ref.handleElementRename(finderMethod.toString());
                continue;
            }
            usagesList.add(usage);
        }
        super.renameElement(psiElement, newName, usagesList.size() == usages.length ? usages : usagesList.toArray(new UsageInfo[usagesList.size()]), listener);
    }

    private static boolean isAddToOrRemoveFromName(String methodName, String capName) {
        return DomainFieldRenameProcessor.stringEquals(methodName, "addTo", capName) || DomainFieldRenameProcessor.stringEquals(methodName, "removeFrom", capName);
    }

    private static boolean stringEquals(String s2, String prefix, String suffix) {
        return s2.length() == prefix.length() + suffix.length() && s2.startsWith(prefix) && s2.endsWith(suffix);
    }

    private static class FinderMethodFieldReference
    extends PsiReferenceBase<PsiElement> {
        private final GrField myField;

        public FinderMethodFieldReference(GrReferenceExpression refExpr, TextRange range, GrField field) {
            super((PsiElement)refExpr, range);
            this.myField = field;
        }

        public PsiElement resolve() {
            return this.myField;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/DomainFieldRenameProcessor$FinderMethodFieldReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

