/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain.namedQuery;

import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.domain.namedQuery.NamedQueryDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GormNamedQueryDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement element, int offsetInElement, Consumer<PomTarget> consumer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/domain/namedQuery/GormNamedQueryDeclarationSearcher", "findDeclarationsAt"));
        }
        if (!GormUtils.isNamedQueryDeclaration(element)) {
            return;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        assert (aClass != null);
        DomainDescriptor descriptor = DomainDescriptor.getDescriptor(aClass);
        NamedQueryDescriptor queryDescriptor = descriptor.getNamedQueries().get(((GrReferenceExpression)element).getReferenceName());
        if (queryDescriptor == null) {
            return;
        }
        consumer.consume((Object)queryDescriptor.getVariable());
    }
}

