/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.controller.ActionReference;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GspActionAttributeSupport
extends TagAttributeReferenceProvider {
    public GspActionAttributeSupport() {
        super("action", "g", null);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        String controllerName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
        }
        PsiElement attributeController = gspTagWrapper.getAttributeValue("controller");
        if (attributeController == null) {
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
            if (virtualFile == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            if (psiFile.getViewProvider() instanceof GspFileViewProvider) {
                controllerName = GrailsUtils.getControllerNameByGsp(virtualFile);
                if (controllerName == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
            } else {
                PsiClass controllerClass = PsiUtil.getContainingNotInnerClass((PsiElement)element);
                if (!GrailsArtifact.CONTROLLER.isInstance(controllerClass)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                assert (controllerClass != null);
                controllerName = GrailsArtifact.CONTROLLER.getArtifactName(controllerClass);
            }
        } else {
            controllerName = gspTagWrapper.getAttributeText(attributeController);
            if (controllerName == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new ActionReference(element, element instanceof XmlAttributeValue, controllerName)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspActionAttributeSupport", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

