/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;

public class GspMetaTagSupport
extends TagAttributeReferenceProvider {
    protected GspMetaTagSupport() {
        super("name", "g", new String[]{"meta"});
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
        VirtualFile root = fileIndex.getContentRootForFile(virtualFile);
        if (root == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        VirtualFile properties = root.findChild("application.properties");
        if (properties == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiFile psiPropertiesFile = file.getManager().findFile(properties);
        if (!(psiPropertiesFile instanceof PropertiesFile)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final PropertiesFile propertiesFile = (PropertiesFile)psiPropertiesFile;
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element, element instanceof XmlAttributeValue){

            public PsiElement resolve() {
                String value = this.getValue();
                List propertiesList = propertiesFile.findPropertiesByKey(value);
                return propertiesList.isEmpty() ? null : ((IProperty)propertiesList.get(0)).getPsiElement();
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = propertiesFile.getProperties().toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport$1", "getVariants"));
                }
                return objectArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspMetaTagSupport", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

